/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.AEApi;
import appeng.api.definitions.IComparableDefinition;
import appeng.api.definitions.IDefinitions;
import appeng.items.parts.ItemFacade;
import com.google.common.base.Optional;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public final class FacadeRecipe
implements IRecipe {
    private final IComparableDefinition anchor;
    private final Optional<Item> maybeFacade;

    public FacadeRecipe() {
        IDefinitions definitions = AEApi.instance().definitions();
        this.maybeFacade = definitions.items().facade().maybeItem();
        this.anchor = definitions.parts().cableAnchor();
    }

    public boolean matches(InventoryCrafting inv, World w) {
        return this.getOutput((IInventory)inv, false) != null;
    }

    @Nullable
    private ItemStack getOutput(IInventory inv, boolean createFacade) {
        Iterator i$;
        if (inv.getStackInSlot(0) == null && inv.getStackInSlot(2) == null && inv.getStackInSlot(6) == null && inv.getStackInSlot(8) == null && this.anchor.isSameAs(inv.getStackInSlot(1)) && this.anchor.isSameAs(inv.getStackInSlot(3)) && this.anchor.isSameAs(inv.getStackInSlot(5)) && this.anchor.isSameAs(inv.getStackInSlot(7)) && (i$ = this.maybeFacade.asSet().iterator()).hasNext()) {
            Item facadeItemDefinition = (Item)i$.next();
            ItemFacade facade = (ItemFacade)facadeItemDefinition;
            ItemStack facades = facade.createFacadeForItem(inv.getStackInSlot(4), !createFacade);
            if (facades != null && createFacade) {
                facades.stackSize = 4;
            }
            return facades;
        }
        return null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.getOutput((IInventory)inv, true);
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

