/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.server.ISubCommand;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;

public class ChunkLogger
implements ISubCommand {
    boolean enabled = false;

    @SubscribeEvent
    public void ChunkLoad(ChunkEvent.Load load) {
        if (!load.world.isRemote) {
            AELog.info("Chunk Loaded:   " + load.getChunk().xPosition + ", " + load.getChunk().zPosition, new Object[0]);
            this.displayStack();
        }
    }

    private void displayStack() {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.ChunkLoggerTrace)) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + '.' + e.getMethodName() + " (" + e.getLineNumber() + ')', new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @SubscribeEvent
    public void ChunkLoad(ChunkEvent.Unload unload) {
        if (!unload.world.isRemote) {
            AELog.info("Chunk Unloaded: " + unload.getChunk().xPosition + ", " + unload.getChunk().zPosition, new Object[0]);
            this.displayStack();
        }
    }

    @Override
    public String getHelp(MinecraftServer srv) {
        return "commands.ae2.ChunkLogger";
    }

    @Override
    public void call(MinecraftServer srv, String[] data, ICommandSender sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.ae2.ChunkLoggerOn", new Object[0]));
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.ae2.ChunkLoggerOff", new Object[0]));
        }
    }
}

