/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.services.version.ModVersionFetcher;
import appeng.services.version.Version;
import appeng.services.version.VersionCheckerConfig;
import appeng.services.version.VersionParser;
import appeng.services.version.github.FormattedRelease;
import appeng.services.version.github.ReleaseFetcher;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.Date;
import net.minecraft.nbt.NBTTagCompound;

public final class VersionChecker
implements Runnable {
    private static final int SEC_TO_HOUR = 3600;
    private static final int MS_TO_SEC = 1000;
    private final VersionCheckerConfig config;

    public VersionChecker(VersionCheckerConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        Thread.yield();
        String rawLastCheck = this.config.lastCheck();
        long lastCheck = Long.parseLong(rawLastCheck);
        Date now = new Date();
        long nowInMs = now.getTime();
        long intervalInMs = this.config.interval() * 3600 * 1000;
        long lastAfterInterval = lastCheck + intervalInMs;
        this.processInterval(nowInMs, lastAfterInterval);
        AELog.info("Stopping AE2 VersionChecker", new Object[0]);
    }

    private void processInterval(long nowInMs, long lastAfterInterval) {
        if (nowInMs > lastAfterInterval) {
            String rawModVersion = "rv2-beta-26";
            VersionParser parser = new VersionParser();
            ModVersionFetcher modFetcher = new ModVersionFetcher("rv2-beta-26", parser);
            ReleaseFetcher githubFetcher = new ReleaseFetcher(this.config, parser);
            Version modVersion = modFetcher.get();
            FormattedRelease githubRelease = githubFetcher.get();
            this.processVersions(modVersion, githubRelease);
        } else {
            AELog.info("Last check was just recently.", new Object[0]);
        }
    }

    private void processVersions(Version modVersion, FormattedRelease githubRelease) {
        Version githubVersion = githubRelease.version();
        String modFormatted = modVersion.formatted();
        String ghFormatted = githubVersion.formatted();
        if (githubVersion.isNewerAs(modVersion)) {
            String changelog = githubRelease.changelog();
            if (this.config.shouldNotifyPlayer()) {
                AELog.info("Newer version is available: " + ghFormatted + " (found) > " + modFormatted + " (current)", new Object[0]);
                if (this.config.shouldPostChangelog()) {
                    AELog.info("Changelog: " + changelog, new Object[0]);
                }
            }
            this.interactWithVersionCheckerMod(modFormatted, ghFormatted, changelog);
        } else {
            AELog.info("No newer version is available: " + ghFormatted + "(found) < " + modFormatted + " (current)", new Object[0]);
        }
    }

    private void interactWithVersionCheckerMod(String modFormatted, String ghFormatted, String changelog) {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound versionInf = new NBTTagCompound();
            versionInf.setString("modDisplayName", "Applied Energistics 2");
            versionInf.setString("oldVersion", modFormatted);
            versionInf.setString("newVersion", ghFormatted);
            versionInf.setString("updateUrl", "http://ae-mod.info/builds/appliedenergistics2-" + ghFormatted + ".jar");
            versionInf.setBoolean("isDirectLink", true);
            if (!changelog.isEmpty()) {
                versionInf.setString("changeLog", changelog);
            }
            versionInf.setString("newFileName", "appliedenergistics2-" + ghFormatted + ".jar");
            FMLInterModComms.sendRuntimeMessage((Object)AppEng.instance, (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)versionInf);
            AELog.info("Reported new version to VersionChecker mod.", new Object[0]);
        } else {
            AELog.info("VersionChecker mod is not installed; Proceeding.", new Object[0]);
        }
    }
}

