/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.block.AEBaseBlock;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AEBaseInvTile
extends AEBaseTile
implements ISidedInventory,
IAEAppEngInventory {
    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_AEBaseInvTile(NBTTagCompound data) {
        IInventory inv = this.getInternalInventory();
        NBTTagCompound opt = data.getCompoundTag("inv");
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            NBTTagCompound item = opt.getCompoundTag("item" + x);
            inv.setInventorySlotContents(x, ItemStack.loadItemStackFromNBT((NBTTagCompound)item));
        }
    }

    public abstract IInventory getInternalInventory();

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_AEBaseInvTile(NBTTagCompound data) {
        IInventory inv = this.getInternalInventory();
        NBTTagCompound opt = new NBTTagCompound();
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            NBTTagCompound item = new NBTTagCompound();
            ItemStack is = this.getStackInSlot(x);
            if (is != null) {
                is.writeToNBT(item);
            }
            opt.setTag("item" + x, (NBTBase)item);
        }
        data.setTag("inv", (NBTBase)opt);
    }

    public int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public ItemStack getStackInSlot(int i) {
        return this.getInternalInventory().getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.getInternalInventory().decrStackSize(i, j);
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(i, itemstack);
    }

    public String getInventoryName() {
        return this.getCustomName();
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer p) {
        double squaredMCReach = 64.0;
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && p.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public abstract void onChangeInventory(IInventory var1, int var2, InvOperation var3, ItemStack var4, ItemStack var5);

    public final int[] getAccessibleSlotsFromSide(int side) {
        Block blk = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
        if (blk instanceof AEBaseBlock) {
            ForgeDirection mySide = ForgeDirection.getOrientation((int)side);
            return this.getAccessibleSlotsBySide(((AEBaseBlock)blk).mapRotation(this, mySide));
        }
        return this.getAccessibleSlotsBySide(ForgeDirection.getOrientation((int)side));
    }

    public boolean canInsertItem(int slotIndex, ItemStack insertingItem, int side) {
        return this.isItemValidForSlot(slotIndex, insertingItem);
    }

    public boolean canExtractItem(int slotIndex, ItemStack extractedItem, int side) {
        return true;
    }

    public abstract int[] getAccessibleSlotsBySide(ForgeDirection var1);
}

