/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.util.IConfigManager;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileCellWorkbench
extends AEBaseTile
implements IUpgradeableHost,
IAEAppEngInventory,
IConfigManagerHost {
    final AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 63);
    final ConfigManager cm = new ConfigManager(this);
    IInventory cacheUpgrades = null;
    IInventory cacheConfig = null;
    private boolean locked = false;

    public TileCellWorkbench() {
        this.cm.registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE);
        this.cell.enableClientEvents = true;
    }

    public IInventory getCellUpgradeInventory() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cell.getUpgradesInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getStackInSlot(0) == null) {
            return null;
        }
        if (this.cell.getStackInSlot(0).getItem() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getStackInSlot(0).getItem();
        }
        return null;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCellWorkbench(NBTTagCompound data) {
        this.cell.writeToNBT(data, "cell");
        this.config.writeToNBT(data, "config");
        this.cm.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCellWorkbench(NBTTagCompound data) {
        this.cell.readFromNBT(data, "cell");
        this.config.readFromNBT(data, "config");
        this.cm.readFromNBT(data);
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("cell")) {
            return this.cell;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        IInventory c;
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            this.cacheUpgrades = null;
            this.cacheConfig = null;
            IInventory c2 = this.getCellConfigInventory();
            if (c2 != null) {
                int x;
                boolean cellHasConfig = false;
                for (x = 0; x < c2.getSizeInventory(); ++x) {
                    if (c2.getStackInSlot(x) == null) continue;
                    cellHasConfig = true;
                    break;
                }
                if (cellHasConfig) {
                    for (x = 0; x < this.config.getSizeInventory(); ++x) {
                        this.config.setInventorySlotContents(x, c2.getStackInSlot(x));
                    }
                } else {
                    for (x = 0; x < this.config.getSizeInventory(); ++x) {
                        c2.setInventorySlotContents(x, this.config.getStackInSlot(x));
                    }
                    c2.markDirty();
                }
            } else if (this.cm.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                for (int x = 0; x < this.config.getSizeInventory(); ++x) {
                    this.config.setInventorySlotContents(x, null);
                }
                this.markDirty();
            }
            this.locked = false;
        } else if (inv == this.config && !this.locked && (c = this.getCellConfigInventory()) != null) {
            for (int x = 0; x < this.config.getSizeInventory(); ++x) {
                c.setInventorySlotContents(x, this.config.getStackInSlot(x));
            }
            c.markDirty();
        }
    }

    public IInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
            return this.cacheConfig;
        }
        return this.cacheConfig;
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        if (this.cell.getStackInSlot(0) != null) {
            drops.add(this.cell.getStackInSlot(0));
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }
}

