/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.ITileDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuantumBridge
extends AENetworkInvTile
implements IAEMultiBlock {
    private static final IBlockDefinition RING_DEFINITION = AEApi.instance().definitions().blocks().quantumRing();
    public final byte corner = (byte)16;
    final int[] sidesRing = new int[0];
    final int[] sidesLink = new int[]{0};
    final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1);
    final byte hasSingularity = (byte)32;
    final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    public boolean bridgePowered;
    byte constructed = (byte)-1;
    QuantumCluster cluster;
    private boolean updateStatus = false;

    public TileQuantumBridge() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.gridProxy.setFlags(GridFlags.DENSE_CAPACITY);
        this.gridProxy.setIdlePowerUsage(22.0);
        this.internalInventory.setMaxStackSize(1);
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTickEvent() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onNetworkWriteEvent(ByteBuf data) {
        int out = this.constructed;
        if (this.getStackInSlot(0) != null && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.gridProxy.isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean onNetworkReadEvent(ByteBuf data) {
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        this.bridgePowered = (this.constructed | this.powered) == this.powered;
        return this.constructed != oldValue;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        if (this.isCenter()) {
            return this.sidesLink;
        }
        return this.sidesRing;
    }

    public boolean isCenter() {
        Iterator i$ = AEApi.instance().definitions().blocks().quantumLink().maybeBlock().asSet().iterator();
        if (i$.hasNext()) {
            Block link = (Block)i$.next();
            return this.getBlockType() == link;
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    @Override
    public void onReady() {
        boolean isPresent;
        super.onReady();
        ITileDefinition quantumRing = AEApi.instance().definitions().blocks().quantumRing();
        Optional<Block> maybeLinkBlock = quantumRing.maybeBlock();
        Optional<ItemStack> maybeLinkStack = quantumRing.maybeStack(1);
        boolean bl = isPresent = maybeLinkBlock.isPresent() && maybeLinkStack.isPresent();
        if (isPresent && this.getBlockType() == maybeLinkBlock.get()) {
            ItemStack linkStack = (ItemStack)maybeLinkStack.get();
            this.gridProxy.setVisualRepresentation(linkStack);
        }
    }

    @Override
    public void invalidate() {
        this.disconnect(false);
        super.invalidate();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.updateStatus = false;
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                this.gridProxy.setValidSides(this.getConnections());
            } else {
                this.gridProxy.setValidSides(EnumSet.allOf(ForgeDirection.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.corner) == this.corner && this.constructed != -1;
    }

    public EnumSet<ForgeDirection> getConnections() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord + d.offsetX, this.yCoord + d.offsetY, this.zCoord + d.offsetZ);
            if (!(te instanceof TileQuantumBridge)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        NBTTagCompound c;
        ItemStack is = this.internalInventory.getStackInSlot(0);
        if (is != null && (c = is.getTagCompound()) != null) {
            return c.getLong("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.gridProxy.getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.worldObj, this.getLocation());
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }
}

