/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.commands;

import codechicken.lib.util.ServerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class CoreCommand
implements ICommand {
    public static void chatT(ICommandSender sender, String s, Object ... params) {
        sender.addChatMessage((ITextComponent)new TextComponentTranslation(s, params));
    }

    public static void chatOpsT(String s, Object ... params) {
        for (EntityPlayerMP player : ServerUtils.getPlayers()) {
            if (!FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList().canSendCommands(player.getGameProfile())) continue;
            player.addChatMessage((ITextComponent)new TextComponentTranslation(s, params));
        }
    }

    public abstract boolean isOpOnly();

    public String getCommandUsage(ICommandSender commandSender) {
        return "/" + this.getCommandName() + " help";
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < this.minimumParameters() || args.length == 1 && args[0].equals("help")) {
            this.printHelp(sender);
            return;
        }
        String command = this.getCommandName();
        for (String arg : args) {
            command = command + " " + arg;
        }
        this.handleCommand(command, sender.getName(), args, sender);
    }

    public abstract void handleCommand(String var1, String var2, String[] var3, ICommandSender var4);

    public abstract void printHelp(ICommandSender var1);

    public final EntityPlayerMP getPlayer(String name) {
        return ServerUtils.getPlayer((String)name);
    }

    public WorldServer getWorld(int dimension) {
        return DimensionManager.getWorld((int)dimension);
    }

    public WorldServer getWorld(EntityPlayer player) {
        return (WorldServer)player.worldObj;
    }

    public int compareTo(ICommand o) {
        return this.getCommandName().compareTo(o.getCommandName());
    }

    public List<String> getCommandAliases() {
        return new ArrayList<String>();
    }

    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }

    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }

    public boolean checkPermission(MinecraftServer server, ICommandSender commandSender) {
        if (this.isOpOnly()) {
            if (commandSender instanceof EntityPlayer) {
                return FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList().canSendCommands(((EntityPlayer)commandSender).getGameProfile());
            }
            return commandSender instanceof MinecraftServer;
        }
        return true;
    }

    public abstract int minimumParameters();
}

