/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.gui.GuiWidget;
import codechicken.core.gui.IGuiActionListener;
import codechicken.lib.gui.GuiDraw;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;

public class GuiContainerWidget
extends GuiContainer
implements IGuiActionListener {
    public ArrayList<GuiWidget> widgets = new ArrayList();

    public GuiContainerWidget(Container inventorySlots) {
        this(inventorySlots, 176, 166);
    }

    public GuiContainerWidget(Container inventorySlots, int xSize, int ySize) {
        super(inventorySlots);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void setWorldAndResolution(Minecraft mc, int i, int j) {
        super.setWorldAndResolution(mc, i, j);
        if (this.widgets.isEmpty()) {
            this.addWidgets();
        }
    }

    public void add(GuiWidget widget) {
        this.widgets.add(widget);
        widget.onAdded((GuiScreen)this);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mousex, int mousey) {
        GlStateManager.translate((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawBackground();
        for (GuiWidget widget : this.widgets) {
            widget.draw(mousex - this.guiLeft, mousey - this.guiTop, f);
        }
        GlStateManager.translate((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
    }

    public void drawBackground() {
    }

    protected void mouseClicked(int x, int y, int button) throws IOException {
        super.mouseClicked(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseClicked(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        for (GuiWidget widget : this.widgets) {
            widget.mouseReleased(x - this.guiLeft, y - this.guiTop, button);
        }
    }

    protected void mouseClickMove(int x, int y, int button, long time) {
        super.mouseClickMove(x, y, button, time);
        for (GuiWidget widget : this.widgets) {
            widget.mouseDragged(x - this.guiLeft, y - this.guiTop, button, time);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.mc.currentScreen == this) {
            for (GuiWidget widget : this.widgets) {
                widget.update();
            }
        }
    }

    public void keyTyped(char c, int keycode) throws IOException {
        super.keyTyped(c, keycode);
        for (GuiWidget widget : this.widgets) {
            widget.keyTyped(c, keycode);
        }
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            Point p = GuiDraw.getMousePosition();
            int scroll = i > 0 ? 1 : -1;
            for (GuiWidget widget : this.widgets) {
                widget.mouseScrolled(p.x, p.y, scroll);
            }
        }
    }

    @Override
    public void actionPerformed(String ident, Object ... params) {
    }

    public void addWidgets() {
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.widgets.clear();
    }
}

