/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class MappedInventoryAccess
implements IInventory {
    public static final InventoryAccessor fullAccess = new InventoryAccessor(){

        @Override
        public boolean canAccessSlot(int slot) {
            return true;
        }
    };
    private ArrayList<Integer> slotMap = new ArrayList();
    private IInventory inv;
    private ArrayList<InventoryAccessor> accessors = new ArrayList();

    public MappedInventoryAccess(IInventory inv, InventoryAccessor ... accessors) {
        this.inv = inv;
        Collections.addAll(this.accessors, accessors);
        this.reset();
    }

    public void reset() {
        this.slotMap.clear();
        block0: for (int i = 0; i < this.inv.getSizeInventory(); ++i) {
            for (InventoryAccessor a : this.accessors) {
                if (a.canAccessSlot(i)) continue;
                continue block0;
            }
            this.slotMap.add(i);
        }
    }

    public int getSizeInventory() {
        return this.slotMap.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(this.slotMap.get(slot).intValue());
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(this.slotMap.get(slot).intValue(), amount);
    }

    public ItemStack removeStackFromSlot(int slot) {
        return this.inv.removeStackFromSlot(this.slotMap.get(slot).intValue());
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(this.slotMap.get(slot).intValue(), stack);
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.inv.isUseableByPlayer(player);
    }

    public void addAccessor(InventoryAccessor accessor) {
        this.accessors.add(accessor);
        this.reset();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.inv.isItemValidForSlot(this.slotMap.get(slot).intValue(), stack);
    }

    public void openInventory(EntityPlayer player) {
        this.inv.openInventory(player);
    }

    public void closeInventory(EntityPlayer player) {
        this.inv.closeInventory(player);
    }

    public int getField(int id) {
        return this.inv.getField(id);
    }

    public void setField(int id, int value) {
        this.inv.setField(id, value);
    }

    public int getFieldCount() {
        return this.inv.getFieldCount();
    }

    public void clear() {
        this.inv.clear();
    }

    public String getName() {
        return this.inv.getName();
    }

    public boolean hasCustomName() {
        return this.inv.hasCustomName();
    }

    public ITextComponent getDisplayName() {
        return this.inv.getDisplayName();
    }

    public List<InventoryAccessor> accessors() {
        return this.accessors;
    }

    public static interface InventoryAccessor {
        public boolean canAccessSlot(int var1);
    }
}

