/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.SlotHandleClicks;
import codechicken.lib.inventory.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class SlotDummy
extends SlotHandleClicks {
    public final int stackLimit;

    public SlotDummy(IInventory inv, int slot, int x, int y) {
        this(inv, slot, x, y, 64);
    }

    public SlotDummy(IInventory inv, int slot, int x, int y, int limit) {
        super(inv, slot, x, y);
        this.stackLimit = limit;
    }

    @Override
    public ItemStack slotClick(ContainerExtended container, EntityPlayer player, int button, ClickType clickType) {
        ItemStack held = player.inventory.getItemStack();
        boolean shift = clickType == ClickType.QUICK_MOVE;
        this.slotClick(held, button, shift);
        return null;
    }

    public void slotClick(ItemStack held, int button, boolean shift) {
        ItemStack tstack = this.getStack();
        if (!(held == null || tstack != null && InventoryUtils.canStack((ItemStack)held, (ItemStack)tstack))) {
            int quantity = Math.min(held.stackSize, this.stackLimit);
            if (shift) {
                quantity = Math.min(this.stackLimit, held.getMaxStackSize() * 16);
            }
            if (button == 1) {
                quantity = 1;
            }
            this.putStack(InventoryUtils.copyStack((ItemStack)held, (int)quantity));
        } else if (tstack != null) {
            int quantity;
            int inc;
            if (held != null) {
                int n = inc = button == 1 ? -held.stackSize : held.stackSize;
                if (shift) {
                    inc *= 16;
                }
            } else {
                int n = inc = button == 1 ? -1 : 1;
                if (shift) {
                    inc *= 16;
                }
            }
            if ((quantity = tstack.stackSize + inc) <= 0) {
                this.putStack(null);
            } else {
                this.putStack(InventoryUtils.copyStack((ItemStack)tstack, (int)quantity));
            }
        }
    }

    public void putStack(ItemStack stack) {
        if (stack != null && stack.stackSize > this.stackLimit) {
            stack = InventoryUtils.copyStack((ItemStack)stack, (int)this.stackLimit);
        }
        super.putStack(stack);
    }
}

