/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.commands;

import codechicken.core.commands.CoreCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.WorldServer;

public abstract class PlayerCommand
extends CoreCommand {
    @Override
    public boolean canCommandSenderUseCommand(ICommandSender var1) {
        if (!super.canCommandSenderUseCommand(var1)) {
            return false;
        }
        return var1 instanceof EntityPlayer;
    }

    @Override
    public void handleCommand(String command, String playername, String[] args, CoreCommand.WCommandSender listener) {
        EntityPlayerMP player = (EntityPlayerMP)listener.wrapped;
        this.handleCommand(this.getWorld((EntityPlayer)player), player, args);
    }

    public abstract void handleCommand(WorldServer var1, EntityPlayerMP var2, String[] var3);

    public ChunkPosition getPlayerLookingAtBlock(EntityPlayerMP player, float reach) {
        Vec3 vec3d = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + 1.62 - (double)player.yOffset), (double)player.posZ);
        Vec3 vec3d1 = player.getLook(1.0f);
        Vec3 vec3d2 = vec3d.addVector(vec3d1.xCoord * (double)reach, vec3d1.yCoord * (double)reach, vec3d1.zCoord * (double)reach);
        MovingObjectPosition hit = player.worldObj.rayTraceBlocks(vec3d, vec3d2);
        if (hit == null || hit.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return null;
        }
        return new ChunkPosition(hit.blockX, hit.blockY, hit.blockZ);
    }

    public Entity getPlayerLookingAtEntity(EntityPlayerMP player, float reach) {
        Vec3 vec3d = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + 1.62 - (double)player.yOffset), (double)player.posZ);
        Vec3 vec3d1 = player.getLook(1.0f);
        Vec3 vec3d2 = vec3d.addVector(vec3d1.xCoord * (double)reach, vec3d1.yCoord * (double)reach, vec3d1.zCoord * (double)reach);
        MovingObjectPosition hit = player.worldObj.rayTraceBlocks(vec3d, vec3d2);
        if (hit == null || hit.typeOfHit != MovingObjectPosition.MovingObjectType.ENTITY) {
            return null;
        }
        return hit.entityHit;
    }
}

