/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerExtended
extends Container
implements ICrafting {
    public LinkedList<EntityPlayerMP> playerCrafters = new LinkedList();

    public ContainerExtended() {
        this.crafters.add(this);
    }

    public void addCraftingToCrafters(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.add((EntityPlayerMP)icrafting);
            this.sendContainerAndContentsToPlayer(this, this.getInventory(), Arrays.asList((EntityPlayerMP)icrafting));
            this.detectAndSendChanges();
        } else {
            super.addCraftingToCrafters(icrafting);
        }
    }

    public void removeCraftingFromCrafters(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.remove(icrafting);
        } else {
            super.removeCraftingFromCrafters(icrafting);
        }
    }

    public void sendContainerAndContentsToPlayer(Container container, List list) {
        this.sendContainerAndContentsToPlayer(container, list, this.playerCrafters);
    }

    public void sendContainerAndContentsToPlayer(Container container, List<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        ItemStack stack;
        LinkedList<ItemStack> largeStacks = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stack = list.get(i);
            if (stack != null && stack.stackSize > 127) {
                list.set(i, null);
                largeStacks.add(stack);
                continue;
            }
            largeStacks.add(null);
        }
        for (EntityPlayerMP player : playerCrafters) {
            player.sendContainerAndContentsToPlayer(container, list);
        }
        for (int i = 0; i < largeStacks.size(); ++i) {
            stack = (ItemStack)largeStacks.get(i);
            if (stack == null) continue;
            this.sendLargeStack(stack, i, playerCrafters);
        }
    }

    public void sendLargeStack(ItemStack stack, int slot, List<EntityPlayerMP> players) {
    }

    public void sendProgressBarUpdate(Container container, int i, int j) {
        for (EntityPlayerMP player : this.playerCrafters) {
            player.sendProgressBarUpdate(container, i, j);
        }
    }

    public void sendSlotContents(Container container, int slot, ItemStack stack) {
        if (stack != null && stack.stackSize > 127) {
            this.sendLargeStack(stack, slot, this.playerCrafters);
        } else {
            for (EntityPlayerMP player : this.playerCrafters) {
                player.sendSlotContents(container, slot, stack);
            }
        }
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer player) {
        Slot slot;
        if (par1 >= 0 && par1 < this.inventorySlots.size() && (slot = this.getSlot(par1)) instanceof SlotHandleClicks) {
            return ((SlotHandleClicks)slot).slotClick(this, player, par2, par3);
        }
        return super.slotClick(par1, par2, par3, player);
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            transferredStack = stack.copy();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return null;
            }
            if (stack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return transferredStack;
    }

    public boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack == null) {
            return false;
        }
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                ItemStack slotStack = slot.getStack();
                if (slotStack != null && slotStack.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getItemDamage() == slotStack.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)slotStack)) {
                    int totalStackSize = slotStack.stackSize + stack.stackSize;
                    int maxStackSize = Math.min(stack.getMaxStackSize(), slot.getSlotStackLimit());
                    if (totalStackSize <= maxStackSize) {
                        stack.stackSize = 0;
                        slotStack.stackSize = totalStackSize;
                        slot.onSlotChanged();
                        merged = true;
                    } else if (slotStack.stackSize < maxStackSize) {
                        stack.stackSize -= maxStackSize - slotStack.stackSize;
                        slotStack.stackSize = maxStackSize;
                        slot.onSlotChanged();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.stackSize > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.stackSize > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                if (!slot.getHasStack() && slot.isItemValid(stack)) {
                    int maxStackSize = Math.min(stack.getMaxStackSize(), slot.getSlotStackLimit());
                    if (stack.stackSize <= maxStackSize) {
                        slot.putStack(stack.copy());
                        slot.onSlotChanged();
                        stack.stackSize = 0;
                        merged = true;
                    } else {
                        slot.putStack(stack.splitStack(maxStackSize));
                        slot.onSlotChanged();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return true;
    }

    public void sendContainerPacket(PacketCustom packet) {
        for (EntityPlayerMP player : this.playerCrafters) {
            packet.sendToPlayer((EntityPlayer)player);
        }
    }

    public void handleOutputPacket(PacketCustom packet) {
    }

    public void handleInputPacket(PacketCustom packet) {
    }

    public void handleGuiChange(int ID, int value) {
    }

    public void sendProgressBarUpdate(int barID, int value) {
        for (ICrafting crafting : this.crafters) {
            crafting.sendProgressBarUpdate((Container)this, barID, value);
        }
    }
}

