/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MappedInventoryAccess
implements IInventory {
    public static final InventoryAccessor fullAccess = new InventoryAccessor(){

        @Override
        public boolean canAccessSlot(int slot) {
            return true;
        }
    };
    private ArrayList<Integer> slotMap = new ArrayList();
    private IInventory inv;
    private ArrayList<InventoryAccessor> accessors = new ArrayList();

    public MappedInventoryAccess(IInventory inv, InventoryAccessor ... accessors) {
        this.inv = inv;
        for (InventoryAccessor a : accessors) {
            this.accessors.add(a);
        }
        this.reset();
    }

    public void reset() {
        this.slotMap.clear();
        block0: for (int i = 0; i < this.inv.getSizeInventory(); ++i) {
            for (InventoryAccessor a : this.accessors) {
                if (a.canAccessSlot(i)) continue;
                continue block0;
            }
            this.slotMap.add(i);
        }
    }

    public int getSizeInventory() {
        return this.slotMap.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(this.slotMap.get(slot).intValue());
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(this.slotMap.get(slot).intValue(), amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(this.slotMap.get(slot).intValue());
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(this.slotMap.get(slot).intValue(), stack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.inv.isUseableByPlayer(player);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public void addAccessor(InventoryAccessor accessor) {
        this.accessors.add(accessor);
        this.reset();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return this.inv.isItemValidForSlot(this.slotMap.get(slot).intValue(), stack);
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public List<InventoryAccessor> accessors() {
        return this.accessors;
    }

    public static interface InventoryAccessor {
        public boolean canAccessSlot(int var1);
    }
}

