/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.launch;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.core.asm.DelegatedTransformer;
import codechicken.core.asm.MCPDeobfuscationTransformer;
import codechicken.core.asm.TweakTransformer;
import codechicken.core.launch.DepLoader;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm", "codechicken.obfuscator"})
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String mcVersion = "[1.7.10]";
    public static final String version = "1.0.4";
    public static File minecraftDir;
    public static String currentMcVersion;
    public static Logger logger;

    public CodeChickenCorePlugin() {
        if (minecraftDir != null) {
            return;
        }
        minecraftDir = (File)FMLInjectionData.data()[6];
        currentMcVersion = (String)FMLInjectionData.data()[4];
        DepLoader.load();
        this.injectDeobfPlugin();
    }

    private void injectDeobfPlugin() {
        try {
            Class<?> wrapperClass = Class.forName("cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper");
            Constructor<?> wrapperConstructor = wrapperClass.getConstructor(String.class, IFMLLoadingPlugin.class, File.class, Integer.TYPE, String[].class);
            Field f_loadPlugins = CoreModManager.class.getDeclaredField("loadPlugins");
            wrapperConstructor.setAccessible(true);
            f_loadPlugins.setAccessible(true);
            ((List)f_loadPlugins.get(null)).add(2, wrapperConstructor.newInstance("CCCDeobfPlugin", new MCPDeobfuscationTransformer.LoadPlugin(), null, 0, new String[0]));
        }
        catch (Exception e) {
            logger.error("Failed to inject MCPDeobfuscation Transformer", (Throwable)e);
        }
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            logger.error(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your coremods folder and check <a href=\"http://www.minecraftforum.net/topic/909223-\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        CodeChickenCorePlugin.versionCheck(mcVersion, "CodeChickenCore");
        return new String[]{"codechicken.lib.asm.ClassHeirachyManager", "codechicken.core.asm.InterfaceDependancyTransformer", "codechicken.core.asm.TweakTransformer", "codechicken.core.asm.DelegatedTransformer", "codechicken.core.asm.DefaultImplementationTransformer"};
    }

    public String getAccessTransformerClass() {
        return "codechicken.core.asm.CodeChickenAccessTransformer";
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        CodeChickenCoreModContainer.loadConfig();
        TweakTransformer.load();
        this.scanCodeChickenMods();
        return null;
    }

    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        for (File file : modsDir.listFiles()) {
            this.scanMod(file);
        }
        File versionModsDir = new File(minecraftDir, "mods/" + currentMcVersion);
        if (versionModsDir.exists()) {
            for (File file : versionModsDir.listFiles()) {
                this.scanMod(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanMod(File file) {
        if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) {
            return;
        }
        try {
            JarFile jar = new JarFile(file);
            try {
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    return;
                }
                Attributes attr = manifest.getMainAttributes();
                if (attr == null) {
                    return;
                }
                String transformer = attr.getValue("CCTransformer");
                if (transformer != null) {
                    DelegatedTransformer.addTransformer(transformer, jar, file);
                }
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            logger.error("CodeChickenCore: Failed to read jar file: " + file.getName(), (Throwable)e);
        }
    }

    static {
        logger = LogManager.getLogger((String)"CodeChickenCore");
    }
}

