/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class CCModelState
implements IModelState {
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map;
    private final Optional<TRSRTransformation> defaultTransform;

    public CCModelState(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map) {
        this(map, (Optional<TRSRTransformation>)Optional.absent());
    }

    public CCModelState(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map, Optional<TRSRTransformation> defaultTransform) {
        this.map = map;
        this.defaultTransform = defaultTransform;
    }

    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (!(part.isPresent() && part.get() instanceof ItemCameraTransforms.TransformType && this.map.containsKey(part.get()))) {
            return this.defaultTransform;
        }
        return Optional.fromNullable((Object)this.map.get(part.get()));
    }

    public ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms() {
        return IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)this);
    }

    public ItemCameraTransforms toVanillaTransform() {
        ItemTransformVec3f thirdPLeft = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f thirdPRight = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f firstPLeft = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f firstPRight = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f head = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f gui = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f ground = ItemTransformVec3f.field_178366_a;
        ItemTransformVec3f fixed = ItemTransformVec3f.field_178366_a;
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            thirdPLeft = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)) {
            thirdPRight = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND)) {
            firstPLeft = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)) {
            firstPRight = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.HEAD)) {
            head = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.HEAD)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.GUI)) {
            gui = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.GUI)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.GROUND)) {
            ground = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.GROUND)).toItemTransform();
        }
        if (this.map.containsKey((Object)ItemCameraTransforms.TransformType.FIXED)) {
            fixed = ((TRSRTransformation)this.map.get((Object)ItemCameraTransforms.TransformType.FIXED)).toItemTransform();
        }
        return new ItemCameraTransforms(thirdPLeft, thirdPRight, firstPLeft, firstPRight, head, gui, ground, fixed);
    }
}

