/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiDraw {
    public static final GuiHook gui = new GuiHook();
    public static FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
    public static TextureManager renderEngine = Minecraft.getMinecraft().renderEngine;
    public static final String TOOLTIP_LINESPACE = "\u00a7h";
    public static final String TOOLTIP_HANDLER = "\u00a7x";
    private static List<ITooltipLineHandler> tipLineHandlers = new ArrayList<ITooltipLineHandler>();

    public static void drawRect(int x, int y, int w, int h, int colour) {
        GuiDraw.drawGradientRect(x, y, w, h, colour, colour);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        gui.drawGradientRect(x, y, x + w, y + h, colour1, colour2);
    }

    public static void drawTexturedModalRect(int x, int y, int tx, int ty, int w, int h) {
        gui.drawTexturedModalRect(x, y, tx, ty, w, h);
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.drawStringWithShadow(text, x, y, colour);
        } else {
            fontRenderer.drawString(text, x, y, colour);
        }
    }

    public static void drawString(String text, int x, int y, int colour) {
        GuiDraw.drawString(text, x, y, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour, boolean shadow) {
        GuiDraw.drawString(text, x + (w - GuiDraw.getStringWidth(text)) / 2, y + (h - 8) / 2, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour) {
        GuiDraw.drawStringC(text, x, y, w, h, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text) / 2, y, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int colour) {
        GuiDraw.drawStringC(text, x, y, colour, true);
    }

    public static void drawStringR(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text), y, colour, shadow);
    }

    public static void drawStringR(String text, int x, int y, int colour) {
        GuiDraw.drawStringR(text, x, y, colour, true);
    }

    public static int getStringWidth(String s) {
        return fontRenderer.getStringWidth(s);
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution res = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        return new Dimension(res.getScaledWidth(), res.getScaledHeight());
    }

    public static Dimension displayRes() {
        Minecraft mc = Minecraft.getMinecraft();
        return new Dimension(mc.displayWidth, mc.displayHeight);
    }

    public static Point getMousePosition(int eventX, int eventY) {
        Dimension size = GuiDraw.displaySize();
        Dimension res = GuiDraw.displayRes();
        return new Point(eventX * size.width / res.width, size.height - eventY * size.height / res.height - 1);
    }

    public static Point getMousePosition() {
        return GuiDraw.getMousePosition(Mouse.getX(), Mouse.getY());
    }

    public static void changeTexture(String s) {
        CCRenderState.changeTexture(s);
    }

    public static void changeTexture(ResourceLocation r) {
        CCRenderState.changeTexture(r);
    }

    public static void drawTip(int x, int y, String text) {
        GuiDraw.drawMultilineTip(x, y, Arrays.asList(text));
    }

    public static int getTipLineId(ITooltipLineHandler handler) {
        tipLineHandlers.add(handler);
        return tipLineHandlers.size() - 1;
    }

    public static ITooltipLineHandler getTipLine(String line) {
        if (!line.startsWith(TOOLTIP_HANDLER)) {
            return null;
        }
        return tipLineHandlers.get(Integer.parseInt(line.substring(2)));
    }

    public static void drawMultilineTip(int x, int y, List<String> list) {
        GuiDraw.drawMultilineTip(fontRenderer, x, y, list);
    }

    public static void drawMultilineTip(FontRenderer font, int x, int y, List<String> list) {
        ITooltipLineHandler line;
        if (list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        RenderHelper.disableStandardItemLighting();
        int w = 0;
        int h = -2;
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            line = GuiDraw.getTipLine(s);
            Dimension d = line != null ? line.getSize() : new Dimension(font.getStringWidth(s), list.get(i).endsWith(TOOLTIP_LINESPACE) && i + 1 < list.size() ? 12 : 10);
            w = Math.max(w, d.width);
            h += d.height;
        }
        if (x < 8) {
            x = 8;
        } else if (x > GuiDraw.displaySize().width - w - 8 && (x -= 24 + w) < 8) {
            x = 8;
        }
        y = (int)MathHelper.clip(y, 8.0, GuiDraw.displaySize().height - 8 - h);
        gui.incZLevel(300.0f);
        GuiDraw.drawTooltipBox(x - 4, y - 4, w + 7, h + 7);
        for (String s : list) {
            line = GuiDraw.getTipLine(s);
            if (line != null) {
                line.draw(x, y);
                y += line.getSize().height;
                continue;
            }
            font.drawStringWithShadow(s, x, y, -1);
            y += s.endsWith(TOOLTIP_LINESPACE) ? 12 : 10;
        }
        tipLineHandlers.clear();
        gui.incZLevel(-300.0f);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        RenderHelper.enableGUIStandardItemLighting();
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        GuiDraw.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        GuiDraw.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        GuiDraw.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        GuiDraw.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        GuiDraw.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        GuiDraw.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        GuiDraw.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        GuiDraw.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        GuiDraw.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static interface ITooltipLineHandler {
        public Dimension getSize();

        public void draw(int var1, int var2);
    }

    public static class GuiHook
    extends Gui {
        public void setZLevel(float f) {
            this.zLevel = f;
        }

        public float getZLevel() {
            return this.zLevel;
        }

        public void incZLevel(float f) {
            this.zLevel += f;
        }

        public void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
            super.drawGradientRect(par1, par2, par3, par4, par5, par6);
        }
    }
}

