/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import org.apache.logging.log4j.LogManager;

public abstract class ContainerExtended
extends Container
implements ICrafting {
    private static final String netChannel = "CCL:Container";
    private static int nextNetworkID = 0;
    public LinkedList<EntityPlayerMP> playerCrafters = new LinkedList();
    private int netID;

    public ContainerExtended() {
        this.crafters.add(this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.netID = ++nextNetworkID;
        }
    }

    public void addCraftingToCrafters(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.add((EntityPlayerMP)icrafting);
            this.sendNetID((EntityPlayerMP)icrafting);
            this.sendContainerAndContentsToPlayer(this, this.getInventory(), Arrays.asList((EntityPlayerMP)icrafting));
            this.detectAndSendChanges();
        } else {
            super.addCraftingToCrafters(icrafting);
        }
    }

    private void sendNetID(EntityPlayerMP player) {
        if (this.netID == 0) {
            LogManager.getLogger((String)"CodeChickenLib").error("Player added to container with 0 network ID");
        } else {
            new PacketCustom(netChannel, 1).writeInt(this.netID).sendToPlayer((EntityPlayer)player);
        }
    }

    public void removeCraftingFromCrafters(ICrafting icrafting) {
        if (icrafting instanceof EntityPlayerMP) {
            this.playerCrafters.remove(icrafting);
        } else {
            super.removeCraftingFromCrafters(icrafting);
        }
    }

    public void sendContainerAndContentsToPlayer(Container container, List list) {
        this.sendContainerAndContentsToPlayer(container, list, this.playerCrafters);
    }

    public void sendContainerAndContentsToPlayer(Container container, List<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        ItemStack stack;
        LinkedList<ItemStack> largeStacks = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stack = list.get(i);
            if (stack != null && stack.stackSize > 127) {
                list.set(i, null);
                largeStacks.add(stack);
                continue;
            }
            largeStacks.add(null);
        }
        for (EntityPlayerMP player : playerCrafters) {
            player.sendContainerAndContentsToPlayer(container, list);
        }
        for (int i = 0; i < largeStacks.size(); ++i) {
            stack = (ItemStack)largeStacks.get(i);
            if (stack == null) continue;
            this.sendLargeStack(stack, i, playerCrafters);
        }
    }

    public void sendLargeStack(ItemStack stack, int slot, List<EntityPlayerMP> players) {
    }

    public void sendProgressBarUpdate(Container container, int i, int j) {
        for (EntityPlayerMP player : this.playerCrafters) {
            player.sendProgressBarUpdate(container, i, j);
        }
    }

    public void sendSlotContents(Container container, int slot, ItemStack stack) {
        if (stack != null && stack.stackSize > 127) {
            this.sendLargeStack(stack, slot, this.playerCrafters);
        } else {
            for (EntityPlayerMP player : this.playerCrafters) {
                player.sendSlotContents(container, slot, stack);
            }
        }
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer player) {
        Slot slot;
        if (par1 >= 0 && par1 < this.inventorySlots.size() && (slot = this.getSlot(par1)) instanceof SlotHandleClicks) {
            return ((SlotHandleClicks)slot).slotClick(this, player, par2, par3);
        }
        return super.slotClick(par1, par2, par3, player);
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            transferredStack = stack.copy();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return null;
            }
            if (stack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return transferredStack;
    }

    public boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack == null) {
            return false;
        }
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                ItemStack slotStack = slot.getStack();
                if (slotStack != null && slotStack.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getItemDamage() == slotStack.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)slotStack)) {
                    int totalStackSize = slotStack.stackSize + stack.stackSize;
                    int maxStackSize = Math.min(stack.getMaxStackSize(), slot.getSlotStackLimit());
                    if (totalStackSize <= maxStackSize) {
                        stack.stackSize = 0;
                        slotStack.stackSize = totalStackSize;
                        slot.onSlotChanged();
                        merged = true;
                    } else if (slotStack.stackSize < maxStackSize) {
                        stack.stackSize -= maxStackSize - slotStack.stackSize;
                        slotStack.stackSize = maxStackSize;
                        slot.onSlotChanged();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.stackSize > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.stackSize > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                if (!slot.getHasStack() && slot.isItemValid(stack)) {
                    int maxStackSize = Math.min(stack.getMaxStackSize(), slot.getSlotStackLimit());
                    if (stack.stackSize <= maxStackSize) {
                        slot.putStack(stack.copy());
                        slot.onSlotChanged();
                        stack.stackSize = 0;
                        merged = true;
                    } else {
                        slot.putStack(stack.splitStack(maxStackSize));
                        slot.onSlotChanged();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return true;
    }

    public void sendContainerPacket(PacketCustom packet) {
        for (EntityPlayerMP player : this.playerCrafters) {
            packet.sendToPlayer((EntityPlayer)player);
        }
    }

    public PacketCustom getPacket(int type) {
        if (this.netID == 0) {
            LogManager.getLogger((String)"CodeChickenLib").error("Tried to get packet for container with 0 network ID");
        }
        if (type == 1) {
            throw new IllegalArgumentException("Packet type 1 is reserved for network synchronisation in ContainerExtended");
        }
        return new PacketCustom(netChannel, type).writeInt(this.netID);
    }

    public void handleClientPacket(PacketCustom packet) {
    }

    public void handleServerPacket(PacketCustom packet) {
    }

    public void sendProgressBarUpdate(int barID, int value) {
        for (ICrafting crafting : this.crafters) {
            crafting.sendProgressBarUpdate((Container)this, barID, value);
        }
    }

    static {
        PacketCustom.assignHandler(netChannel, new PacketCustom.IClientPacketHandler(){

            @Override
            public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient handler) {
                Container cont = mc.thePlayer.openContainer;
                if (!(cont instanceof ContainerExtended)) {
                    return;
                }
                ContainerExtended c = (ContainerExtended)cont;
                if (packet.getType() == 1) {
                    c.netID = packet.readInt();
                } else if (c.netID == packet.readInt()) {
                    c.handleClientPacket(packet);
                }
            }
        });
        PacketCustom.assignHandler(netChannel, new PacketCustom.IServerPacketHandler(){

            @Override
            public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer handler) {
                Container cont = sender.openContainer;
                if (!(cont instanceof ContainerExtended)) {
                    return;
                }
                ContainerExtended c = (ContainerExtended)cont;
                if (c.netID == packet.readInt()) {
                    c.handleServerPacket(packet);
                }
            }
        });
    }
}

