/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static ItemStack newItemStack(Item item, int size, int damage, NBTTagCompound tag) {
        ItemStack stack = new ItemStack(item, size, damage);
        stack.stackTagCompound = tag;
        return stack;
    }

    public static int actualDamage(ItemStack stack) {
        return Items.diamond.getDamage(stack);
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.getStackInSlot(slot);
        if (item != null) {
            if (item.stackSize <= size) {
                inv.setInventorySlotContents(slot, null);
                inv.markDirty();
                return item;
            }
            ItemStack itemstack1 = item.splitStack(size);
            if (item.stackSize == 0) {
                inv.setInventorySlotContents(slot, null);
            } else {
                inv.setInventorySlotContents(slot, item);
            }
            inv.markDirty();
            return itemstack1;
        }
        return null;
    }

    public static ItemStack getStackInSlotOnClosing(IInventory inv, int slot) {
        ItemStack stack = inv.getStackInSlot(slot);
        inv.setInventorySlotContents(slot, null);
        return stack;
    }

    public static int incrStackSize(ItemStack base, ItemStack addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.stackSize);
        }
        return 0;
    }

    public static int incrStackSize(ItemStack base, int addition) {
        int totalSize = base.stackSize + addition;
        if (totalSize <= base.getMaxStackSize()) {
            return addition;
        }
        if (base.stackSize < base.getMaxStackSize()) {
            return base.getMaxStackSize() - base.stackSize;
        }
        return 0;
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setShort("Slot", (short)i);
            items[i].writeToNBT(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.setInteger("Quantity", items[i].stackSize);
            } else if (maxQuantity > 127) {
                tag.setShort("Quantity", (short)items[i].stackSize);
            }
            tagList.appendTag((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tag = tagList.getCompoundTagAt(i);
            short b = tag.getShort("Slot");
            items[b] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
            if (!tag.hasKey("Quantity")) continue;
            items[b].stackSize = ((NBTBase.NBTPrimitive)tag.getTag("Quantity")).func_150287_d();
        }
    }

    public static void dropItem(ItemStack stack, World world, Vector3 dropLocation) {
        EntityItem item = new EntityItem(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.motionX = world.rand.nextGaussian() * 0.05;
        item.motionY = world.rand.nextGaussian() * 0.05 + (double)0.2f;
        item.motionZ = world.rand.nextGaussian() * 0.05;
        world.spawnEntityInWorld((Entity)item);
    }

    public static ItemStack copyStack(ItemStack stack, int quantity) {
        if (stack == null) {
            return null;
        }
        stack = stack.copy();
        stack.stackSize = quantity;
        return stack;
    }

    public static int getInsertibleQuantity(InventoryRange inv, ItemStack stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        for (int slot : inv.slots) {
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
        }
        return quantity;
    }

    public static int getInsertibleQuantity(IInventory inv, ItemStack stack) {
        return InventoryUtils.getInsertibleQuantity(new InventoryRange(inv), stack);
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.getStackInSlot(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = base != null ? InventoryUtils.incrStackSize(base, inv.inv.getInventoryStackLimit() - base.stackSize) : inv.inv.getInventoryStackLimit();
        return Math.min(fit, stack.stackSize);
    }

    public static int fitStackInSlot(IInventory inv, int slot, ItemStack stack) {
        return InventoryUtils.fitStackInSlot(new InventoryRange(inv), slot, stack);
    }

    public static int insertItem(InventoryRange inv, ItemStack stack, boolean simulate) {
        stack = stack.copy();
        for (int pass = 0; pass < 2; ++pass) {
            int[] arr$ = inv.slots;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fit;
                int slot;
                ItemStack base;
                if (pass == 0 == ((base = inv.inv.getStackInSlot(slot = arr$[i$])) == null) || (fit = InventoryUtils.fitStackInSlot(inv, slot, stack)) == 0) continue;
                if (base != null) {
                    stack.stackSize -= fit;
                    if (!simulate) {
                        base.stackSize += fit;
                        inv.inv.setInventorySlotContents(slot, base);
                    }
                } else {
                    if (!simulate) {
                        inv.inv.setInventorySlotContents(slot, InventoryUtils.copyStack(stack, fit));
                    }
                    stack.stackSize -= fit;
                }
                if (stack.stackSize != 0) continue;
                return 0;
            }
        }
        return stack.stackSize;
    }

    public static int insertItem(IInventory inv, ItemStack stack, boolean simulate) {
        return InventoryUtils.insertItem(new InventoryRange(inv), stack, simulate);
    }

    public static ItemStack getExtractableStack(InventoryRange inv, int slot) {
        ItemStack stack = inv.inv.getStackInSlot(slot);
        if (stack == null || !inv.canExtractItem(slot, stack)) {
            return null;
        }
        return stack;
    }

    public static ItemStack getExtractableStack(IInventory inv, int slot) {
        return InventoryUtils.getExtractableStack(new InventoryRange(inv), slot);
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.getItem() == stack2.getItem() && stack1.getItemDamage() == stack2.getItemDamage() && stack1.stackSize == stack2.stackSize && Objects.equal((Object)stack1.getTagCompound(), (Object)stack2.getTagCompound());
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            return InventoryUtils.getChest((TileEntityChest)tile);
        }
        return (IInventory)tile;
    }

    public static IInventory getChest(TileEntityChest chest) {
        for (ForgeDirection fside : chestSides) {
            if (chest.getWorldObj().getBlock(chest.xCoord + fside.offsetX, chest.yCoord + fside.offsetY, chest.zCoord + fside.offsetZ) != chest.getBlockType()) continue;
            return new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)chest.getWorldObj().getTileEntity(chest.xCoord + fside.offsetX, chest.yCoord + fside.offsetY, chest.zCoord + fside.offsetZ)), (IInventory)chest);
        }
        return chest;
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.getItem() == stack2.getItem() && (!stack2.getHasSubtypes() || stack2.getItemDamage() == stack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack2, (ItemStack)stack1) && stack1.isStackable();
    }

    public static void consumeItem(IInventory inv, int slot) {
        ItemStack stack = inv.getStackInSlot(slot);
        Item item = stack.getItem();
        if (item.hasContainerItem(stack)) {
            ItemStack container = item.getContainerItem(stack);
            inv.setInventorySlotContents(slot, container);
        } else {
            inv.decrStackSize(slot, 1);
        }
    }

    public static int stackSize(IInventory inv, int slot) {
        ItemStack stack = inv.getStackInSlot(slot);
        return stack == null ? 0 : stack.stackSize;
    }

    public static void dropOnClose(EntityPlayer player, IInventory inv) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlotOnClosing(i);
            if (stack == null) continue;
            player.dropPlayerItemWithRandomChoice(stack, false);
        }
    }

    public static NBTTagCompound savePersistant(ItemStack stack, NBTTagCompound tag) {
        stack.writeToNBT(tag);
        tag.removeTag("id");
        tag.setString("name", Item.itemRegistry.getNameForObject((Object)stack.getItem()));
        return tag;
    }

    public static ItemStack loadPersistant(NBTTagCompound tag) {
        String name = tag.getString("name");
        Item item = (Item)Item.itemRegistry.getObject(name);
        if (item == null) {
            return null;
        }
        byte count = tag.hasKey("Count") ? tag.getByte("Count") : (byte)1;
        short damage = tag.hasKey("Damage") ? tag.getShort("Damage") : (short)0;
        ItemStack stack = new ItemStack(item, (int)count, (int)damage);
        if (tag.hasKey("tag", 10)) {
            stack.stackTagCompound = tag.getCompoundTag("tag");
        }
        return stack;
    }
}

