/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.util.Copyable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public final class Frequency
implements Copyable<Frequency> {
    @Deprecated
    public static final EnumColour[] colours = new EnumColour[]{EnumColour.WHITE, EnumColour.ORANGE, EnumColour.MAGENTA, EnumColour.LIGHT_BLUE, EnumColour.YELLOW, EnumColour.LIME, EnumColour.PINK, EnumColour.GRAY, EnumColour.LIGHT_GRAY, EnumColour.CYAN, EnumColour.PURPLE, EnumColour.BLUE, EnumColour.BROWN, EnumColour.GREEN, EnumColour.RED, EnumColour.BLACK};
    public int left;
    public int middle;
    public int right;
    public String owner;

    public Frequency() {
        this(0, 0, 0, null);
    }

    public Frequency(int left, int middle, int right, String owner) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.owner = owner;
    }

    public Frequency(int left, int middle, int right) {
        this(left, middle, right, null);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right, String owner) {
        this(left.ordinal(), middle.ordinal(), right.ordinal(), owner);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, null);
    }

    public static Frequency fromString(String left, String middle, String right, String owner) {
        EnumColour c1 = EnumColour.fromName((String)left);
        EnumColour c2 = EnumColour.fromName((String)middle);
        EnumColour c3 = EnumColour.fromName((String)right);
        if (c1 == null) {
            throw new RuntimeException(left + " is an invalid colour!");
        }
        if (c2 == null) {
            throw new RuntimeException(middle + " is an invalid colour!");
        }
        if (c3 == null) {
            throw new RuntimeException(right + " is an invalid colour!");
        }
        return new Frequency(c1, c2, c3, owner);
    }

    public static Frequency fromString(String left, String middle, String right) {
        return Frequency.fromString(left, middle, right, null);
    }

    public Frequency setLeft(int left) {
        this.left = left;
        return this;
    }

    public Frequency setMiddle(int middle) {
        this.middle = middle;
        return this;
    }

    public Frequency setRight(int right) {
        this.right = right;
        return this;
    }

    public Frequency setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public static Frequency fromArray(int[] colours) {
        Frequency frequency = new Frequency();
        frequency.setLeft(colours[0]);
        frequency.setMiddle(colours[1]);
        frequency.setRight(colours[2]);
        return frequency;
    }

    public Frequency setFrequency(int left, int middle, int right) {
        this.setLeft(left);
        this.setMiddle(middle);
        this.setRight(right);
        return this;
    }

    public Frequency setFrequency(Frequency frequency) {
        this.setLeft(frequency.left);
        this.setMiddle(frequency.middle);
        this.setRight(frequency.right);
        this.setOwner(frequency.owner);
        return this;
    }

    public String getLeft() {
        return EnumColour.values()[this.left].getMinecraftName();
    }

    public String getMiddle() {
        return EnumColour.values()[this.middle].getMinecraftName();
    }

    public String getRight() {
        return EnumColour.values()[this.right].getMinecraftName();
    }

    public EnumColour getLeftRaw() {
        return EnumColour.values()[this.left];
    }

    public EnumColour getMiddleRaw() {
        return EnumColour.values()[this.middle];
    }

    public EnumColour getRightRaw() {
        return EnumColour.values()[this.right];
    }

    public String getLocalizedLeft() {
        return I18n.translateToLocal((String)this.getLeftRaw().getUnlocalizedName());
    }

    public String getLocalizedMiddle() {
        return I18n.translateToLocal((String)this.getMiddleRaw().getUnlocalizedName());
    }

    public String getLocalizedRight() {
        return I18n.translateToLocal((String)this.getRightRaw().getUnlocalizedName());
    }

    public String[] getColours() {
        return new String[]{this.getLeft(), this.getMiddle(), this.getRight()};
    }

    public int[] toArray() {
        return new int[]{this.left, this.middle, this.right};
    }

    public Frequency readNBT(NBTTagCompound tagCompound) {
        this.left = tagCompound.getInteger("left");
        this.middle = tagCompound.getInteger("middle");
        this.right = tagCompound.getInteger("right");
        if (tagCompound.hasKey("owner")) {
            this.owner = tagCompound.getString("owner");
        }
        return this;
    }

    public Frequency writeNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("left", this.left);
        tagCompound.setInteger("middle", this.middle);
        tagCompound.setInteger("right", this.right);
        if (this.owner != null) {
            tagCompound.setString("owner", this.owner);
        }
        return this;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeNBT(tagCompound);
        return tagCompound;
    }

    public static Frequency fromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound frequencyTag = tagCompound;
        if (tagCompound.hasKey("Frequency")) {
            frequencyTag = tagCompound.getCompoundTag("Frequency");
        }
        return new Frequency().readNBT(frequencyTag);
    }

    public static Frequency fromItemStack(ItemStack stack) {
        Frequency frequency = new Frequency();
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("Frequency")) {
            NBTTagCompound tagCompound = stack.getTagCompound().getCompoundTag("Frequency");
            frequency.setFrequency(Frequency.fromNBT(tagCompound));
        }
        return frequency;
    }

    public static ItemStack toItemStack(ItemStack stack, Frequency frequency) {
        return frequency.toItemStack(stack);
    }

    public ItemStack toItemStack(ItemStack stack) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (stack.hasTagCompound()) {
            tagCompound = stack.getTagCompound();
        }
        NBTTagCompound frequencyTag = new NBTTagCompound();
        this.writeNBT(frequencyTag);
        tagCompound.setTag("Frequency", (NBTBase)frequencyTag);
        stack.setTagCompound(tagCompound);
        return stack;
    }

    public String toModelLoc() {
        return "left=" + this.getLeft() + ",middle=" + this.getMiddle() + ",right=" + this.getRight() + ",owned=" + this.hasOwner();
    }

    public String toString() {
        String owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + this.owner;
        }
        return "left=" + this.getLeft() + ",middle=" + this.getMiddle() + ",right=" + this.getRight() + owner;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Frequency copy() {
        return new Frequency(this.left, this.middle, this.right, this.owner);
    }
}

