/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.init.EnderStorageRecipe;
import codechicken.enderstorage.reference.VariantReference;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.block.property.PropertyString;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderStorage
extends Block
implements ITileEntityProvider {
    public static final PropertyString VARIANTS = new PropertyString("type", VariantReference.enderBlockNamesList);

    public BlockEnderStorage() {
        super(Material.ROCK);
        this.setHardness(20.0f);
        this.setResistance(100.0f);
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        this.setUnlocalizedName("enderStorage");
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEnderChest();
            }
            case 1: {
                return new TileEnderTank();
            }
        }
        return null;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.harvestBlock(worldIn, player, pos, state, te, stack);
        worldIn.setBlockToAir(pos);
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        super.breakBlock(worldIn, pos, state);
        worldIn.removeTileEntity(pos);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(pos);
        if (tile != null) {
            ret.add(this.createItem(state.getBlock().getMetaFromState(state), tile.frequency));
            if (ConfigurationHandler.anarchyMode && tile.frequency.hasOwner()) {
                ret.add(ConfigurationHandler.personalItem.copy());
            }
        }
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult rayTraceResult, World world, BlockPos pos, EntityPlayer player) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(pos);
        return this.createItem(this.getMetaFromState(state), tile.frequency);
    }

    private ItemStack createItem(int meta, Frequency freq) {
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if (ConfigurationHandler.anarchyMode) {
            freq.setOwner(null);
        }
        stack.getTagCompound().setTag("Frequency", (NBTBase)freq.toNBT());
        return stack;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item;
        int dye;
        if (world.isRemote) {
            return true;
        }
        TileEntity tile = world.getTileEntity(pos);
        if (!(tile instanceof TileFrequencyOwner)) {
            return false;
        }
        TileFrequencyOwner owner = (TileFrequencyOwner)tile;
        RayTraceResult hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
        if (hit == null) {
            return false;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.inventory.getCurrentItem();
            if (player.isSneaking() && owner.frequency.hasOwner()) {
                if (!player.capabilities.isCreativeMode && !player.inventory.addItemStackToInventory(ConfigurationHandler.personalItem.copy())) {
                    return false;
                }
                owner.setFreq(owner.frequency.copy().setOwner(null));
                return true;
            }
            if (item2 != null && ItemUtils.areStacksSameTypeCrafting((ItemStack)item2, (ItemStack)ConfigurationHandler.personalItem) && !owner.frequency.hasOwner()) {
                owner.setFreq(owner.frequency.copy().setOwner(player.getDisplayNameString()));
                if (!player.capabilities.isCreativeMode) {
                    --item2.stackSize;
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && (dye = EnderStorageRecipe.getDyeType(item = player.inventory.getCurrentItem())) != -1) {
            int[] colours = owner.frequency.toArray();
            if (colours[hit.subHit - 1] == (~dye & 0xF)) {
                return false;
            }
            colours[hit.subHit - 1] = ~dye & 0xF;
            owner.setFreq(Frequency.fromArray(colours));
            if (!player.capabilities.isCreativeMode) {
                --item.stackSize;
            }
            return true;
        }
        return owner.activate(player, hit.subHit, heldItem);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).onPlaced(placer);
        }
    }

    public RayTraceResult collisionRayTrace(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile != null && tile instanceof TileFrequencyOwner) {
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (List)((TileFrequencyOwner)tile).getIndexedCuboids(), (BlockPos)pos);
        }
        return super.collisionRayTrace(state, world, pos, start, end);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileFrequencyOwner owner;
        TileEntity tile = source.getTileEntity(pos);
        if (tile != null && tile instanceof TileFrequencyOwner && !(owner = (TileFrequencyOwner)tile).getIndexedCuboids().isEmpty()) {
            return ((IndexedCuboid6)owner.getIndexedCuboids().get(0)).aabb();
        }
        return super.getBoundingBox(state, source, pos);
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    public int getMetaFromState(IBlockState state) {
        return VariantReference.enderBlockNamesList.indexOf(String.valueOf(state.getValue((IProperty)VARIANTS)));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)VARIANTS, (Comparable)((Object)VariantReference.enderBlockNamesList.get(meta)));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.getTileEntity(pos);
        return tile != null && tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).redstoneInteraction();
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return this.getMetaFromState(state) == 0;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        return tile instanceof TileFrequencyOwner ? ((TileFrequencyOwner)tile).comparatorInput() : 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.getTileEntity(pos);
        return tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).rotate();
    }

    public boolean eventReceived(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.eventReceived(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity != null && tileentity.receiveClientEvent(eventID, eventParam);
    }
}

