/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.gui;

import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.lib.texture.TextureUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.text.translation.I18n;

public class GuiEnderItemStorage
extends GuiContainer {
    private String name;
    private IInventory playerInv;
    private EnderItemStorage chestInv;

    public GuiEnderItemStorage(InventoryPlayer invplayer, EnderItemStorage chestInv, String name) {
        super((Container)new ContainerEnderItemStorage((IInventory)invplayer, chestInv, true));
        this.playerInv = invplayer;
        this.chestInv = chestInv;
        this.allowUserInput = false;
        this.name = I18n.translateToLocal((String)name);
        if (chestInv.getSize() == 2) {
            this.ySize = 222;
        }
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(this.name, 8, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.translateToLocal((String)this.playerInv.getName()), 8, this.ySize - 94, 0x404040);
        ContainerEnderItemStorage ces = (ContainerEnderItemStorage)this.inventorySlots;
        if (ces.chestInv.freq.hasOwner()) {
            this.fontRendererObj.drawString(ces.chestInv.freq.owner, 170 - this.fontRendererObj.getStringWidth(ces.chestInv.freq.owner), 6, 0x404040);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)(this.chestInv.getSize() == 0 ? "textures/gui/container/dispenser.png" : "textures/gui/container/generic_54.png"));
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        switch (this.chestInv.getSize()) {
            case 0: 
            case 2: {
                this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
                break;
            }
            case 1: {
                this.drawTexturedModalRect(x, y, 0, 0, this.xSize, 71);
                this.drawTexturedModalRect(x, y + 71, 0, 126, this.xSize, 96);
            }
        }
    }
}

