/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.model.ModelEnderChest;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.misc.EnderDyeButton;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class RenderTileEnderChest
extends TileEntitySpecialRenderer<TileEnderChest> {
    private static ModelEnderChest model = new ModelEnderChest();
    public static final double phi = 1.618034;
    private static RenderCustomEndPortal renderEndPortal = new RenderCustomEndPortal(0.626, 0.188, 0.812, 0.188, 0.812);

    public void renderTileEntityAt(TileEnderChest enderChest, double x, double y, double z, float partialTicks, int destroyStage) {
        RenderTileEnderChest.renderChest(enderChest.rotation, enderChest.frequency, x, y, z, RenderUtils.getTimeOffset((BlockPos)enderChest.getPos()), (float)enderChest.getRadianLidAngle(partialTicks));
    }

    public static void renderChest(int rotation, Frequency freq, double x, double y, double z, int offset, float lidAngle) {
        TileEntityRendererDispatcher info = TileEntityRendererDispatcher.instance;
        renderEndPortal.render(x, y, z, 0.0f, info.entityX, info.entityY, info.entityZ, info.renderEngine);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)"enderstorage:textures/enderchest.png");
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translate((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.scale((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotate((float)(rotation * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)-0.5f);
        RenderTileEnderChest.model.chestLid.rotateAngleX = lidAngle;
        model.render(freq.hasOwner());
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        RenderTileEnderChest.renderButtons(freq, rotation, lidAngle);
        GlStateManager.popMatrix();
        double time = ClientUtils.getRenderTime() + (double)offset;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.2 + (double)lidAngle * -0.5 + (double)RenderUtils.getPearlBob((double)time), z + 0.5), (Rotation)new Rotation(time / 3.0, new Vector3(0.0, 1.0, 0.0)), (double)0.04);
        GlStateManager.disableLighting();
        TextureUtils.changeTexture((String)"enderstorage:textures/hedronmap.png");
        GlStateManager.pushMatrix();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }

    private static void renderButtons(Frequency freq, int rot, double lidAngle) {
        TextureUtils.changeTexture((String)"enderstorage:textures/buttons.png");
        RenderTileEnderChest.drawButton(0, freq.left, rot, lidAngle);
        RenderTileEnderChest.drawButton(1, freq.middle, rot, lidAngle);
        RenderTileEnderChest.drawButton(2, freq.right, rot, lidAngle);
    }

    private static void drawButton(int button, int colour, int rot, double lidAngle) {
        float texx = 0.25f * (float)(colour % 4);
        float texy = 0.25f * (float)(colour / 4);
        GL11.glPushMatrix();
        EnderDyeButton ebutton = TileEnderChest.buttons[button].copy();
        ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, lidAngle);
        ebutton.rotateMeta(rot);
        Vector3[] verts = ebutton.verts;
        Tessellator tessellator = Tessellator.getInstance();
        tessellator.getBuffer().begin(7, DefaultVertexFormats.POSITION_TEX);
        RenderTileEnderChest.addVecWithUV(verts[7], (double)texx + 0.0938, (double)texy + 0.0625);
        RenderTileEnderChest.addVecWithUV(verts[3], (double)texx + 0.0938, (double)texy + 0.1875);
        RenderTileEnderChest.addVecWithUV(verts[2], (double)texx + 0.1562, (double)texy + 0.1875);
        RenderTileEnderChest.addVecWithUV(verts[6], (double)texx + 0.1562, (double)texy + 0.0625);
        RenderTileEnderChest.addVecWithUV(verts[4], (double)texx + 0.0938, (double)texy + 0.0313);
        RenderTileEnderChest.addVecWithUV(verts[7], (double)texx + 0.0938, (double)texy + 0.0313);
        RenderTileEnderChest.addVecWithUV(verts[6], (double)texx + 0.1562, (double)texy + 0.0624);
        RenderTileEnderChest.addVecWithUV(verts[5], (double)texx + 0.1562, (double)texy + 0.0624);
        RenderTileEnderChest.addVecWithUV(verts[0], (double)texx + 0.0938, (double)texy + 0.2186);
        RenderTileEnderChest.addVecWithUV(verts[1], (double)texx + 0.1562, (double)texy + 0.2186);
        RenderTileEnderChest.addVecWithUV(verts[2], (double)texx + 0.1562, (double)texy + 0.1876);
        RenderTileEnderChest.addVecWithUV(verts[3], (double)texx + 0.0938, (double)texy + 0.1876);
        RenderTileEnderChest.addVecWithUV(verts[6], (double)texx + 0.1563, (double)texy + 0.0626);
        RenderTileEnderChest.addVecWithUV(verts[2], (double)texx + 0.1563, (double)texy + 0.1874);
        RenderTileEnderChest.addVecWithUV(verts[1], (double)texx + 0.1874, (double)texy + 0.1874);
        RenderTileEnderChest.addVecWithUV(verts[5], (double)texx + 0.1874, (double)texy + 0.0626);
        RenderTileEnderChest.addVecWithUV(verts[7], (double)texx + 0.0937, (double)texy + 0.0626);
        RenderTileEnderChest.addVecWithUV(verts[4], (double)texx + 0.0626, (double)texy + 0.0626);
        RenderTileEnderChest.addVecWithUV(verts[0], (double)texx + 0.0626, (double)texy + 0.1874);
        RenderTileEnderChest.addVecWithUV(verts[3], (double)texx + 0.0937, (double)texy + 0.1874);
        tessellator.draw();
        GlStateManager.popMatrix();
    }

    private static void addVecWithUV(Vector3 vec, double u, double v) {
        Tessellator.getInstance().getBuffer().pos(vec.x, vec.y, vec.z).tex(u, v).endVertex();
    }
}

