/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.command.sub;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.command.ICCCommand;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.util.LogHelper;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.util.ArrayUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClearCommand
extends CommandBase
implements ICCCommand {
    public String getCommandName() {
        return "clear";
    }

    @Override
    public String getBrief() {
        return "Provides ability to clear a users EnderStorage.";
    }

    @Override
    public List<String> getHelpLines() {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("[] Defines required choice parameters.");
        lines.add("<> Defines optional parameters.");
        lines.add("Syntax: \"/EnderStorage clear [item|liquid|*] [freq|*] <player>\"");
        lines.add("If you don't provide a player it will clear all global Storage's.");
        lines.add("To clear all player Storage's provide \"*\" as the player.");
        lines.add("For frequency syntax use \"/EnderStorage help frequency\"");
        return lines;
    }

    public String getCommandUsage(ICommandSender sender) {
        return this.getBrief();
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Not Enough Arguments!"));
            this.displayHelpText(sender);
            return;
        }
        String identifier = args[0];
        String frequency = args[1];
        String owner = null;
        if (args.length == 3) {
            owner = args[2];
        }
        Set<String> identifiers = EnderStorageManager.getPlugins().keySet();
        if ("*".equals(identifier)) {
            for (String ident : identifiers) {
                ClearCommand.nukeStorage(ident, frequency, owner, sender);
            }
        } else if (identifiers.contains(identifier)) {
            ClearCommand.nukeStorage(identifier, frequency, owner, sender);
        } else {
            sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid Storage Identifier [" + identifier + "]"));
            sender.addChatMessage((ITextComponent)new TextComponentString("For valid Identifiers run, " + TextFormatting.YELLOW + "\"/EnderStorage help validStorage\""));
        }
    }

    private static void nukeStorage(String identifier, String frequency, final String owner, ICommandSender sender) throws CommandException {
        Object frequencyPredicate;
        LogHelper.info("%s %s %s", identifier, frequency, owner);
        EnderStorageManager manager = EnderStorageManager.instance(false);
        List<String> validKeys = manager.getValidKeys(identifier);
        if ("*".equals(frequency)) {
            frequencyPredicate = new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return true;
                }
            };
        } else {
            final String[] split = frequency.split(",");
            if (split != null && split.length == 3) {
                for (String c : split) {
                    boolean valid = false;
                    for (EnumColour colour : EnumColour.values()) {
                        if (!colour.getName().equalsIgnoreCase(c)) continue;
                        valid = true;
                    }
                    if (valid) continue;
                    throw new CommandException(c + " is an invalid colour! \"/EnderStorage help colour\"", new Object[0]);
                }
                frequencyPredicate = new Predicate<String>(){

                    public boolean apply(@Nullable String input) {
                        if (Strings.isNullOrEmpty((String)input)) {
                            return false;
                        }
                        Map kvArray = ArrayUtils.convertKeyValueArrayToMap((String[])input.split(","));
                        return ((String)kvArray.get("left")).equalsIgnoreCase(split[0]) && ((String)kvArray.get("middle")).equalsIgnoreCase(split[1]) && ((String)kvArray.get("right")).equalsIgnoreCase(split[2]);
                    }
                };
            } else {
                throw new CommandException("Invalid frequency format! \"<colour>,<colour>,<colour>\"", new Object[0]);
            }
        }
        Object ownerPredicate = owner == null ? new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input == null;
            }
        } : ("*".equals(owner) ? new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return !Strings.isNullOrEmpty((String)input);
            }
        } : new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return owner.equals(input);
            }
        });
        boolean noStorage = true;
        ArrayList<String> cleared = new ArrayList<String>();
        for (String key : validKeys) {
            LogHelper.info(key);
            Map kvArray = ArrayUtils.convertKeyValueArrayToMap((String[])key.split(","));
            if (!frequencyPredicate.apply((Object)key) || !ownerPredicate.apply(kvArray.get("owner"))) continue;
            noStorage = false;
            Frequency freq = Frequency.fromString((String)kvArray.get("left"), (String)kvArray.get("middle"), (String)kvArray.get("right"), (String)kvArray.get("owner"));
            AbstractEnderStorage storage = manager.getStorage(freq, identifier);
            storage.clearStorage();
            cleared.add(freq.toString());
        }
        if (noStorage) {
            throw new CommandException("No storage's exist for that colour and owner..", new Object[0]);
        }
        sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Successfully cleared " + cleared.size() + " Storage's!"));
        for (String entry : cleared) {
            sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.BLUE + entry));
        }
    }

    private void displayHelpText(ICommandSender sender) {
        for (String line : this.getHelpLines()) {
            sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.BLUE + line));
        }
    }
}

