/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.command.sub;

import codechicken.enderstorage.command.EnderStorageCommand;
import codechicken.enderstorage.command.ICCCommand;
import codechicken.enderstorage.command.help.ColourHelp;
import codechicken.enderstorage.command.help.FrequencyHelp;
import codechicken.enderstorage.command.help.IHelpPage;
import codechicken.enderstorage.command.help.ValidStorageHelp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class HelpCommand
extends CommandBase {
    private EnderStorageCommand parent;
    private List<IHelpPage> helpPages;

    public HelpCommand(EnderStorageCommand parent) {
        this.parent = parent;
        this.helpPages = new LinkedList<IHelpPage>();
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public String getCommandName() {
        return "help";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "Displays help for EnderStorage commands.";
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.displayHelp(server, sender);
        } else if (args.length == 1) {
            String arg = args[0];
            if (this.parent.getCommandMap().containsKey(arg)) {
                ICommand subCommand = (ICommand)this.parent.getCommandMap().get(arg);
                sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Help for: /EnderStorage " + arg));
                if (subCommand instanceof ICCCommand) {
                    for (String line : ((ICCCommand)subCommand).getHelpLines()) {
                        sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.BLUE + line));
                    }
                } else {
                    sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.BLUE + subCommand.getCommandUsage(sender)));
                }
            } else {
                for (IHelpPage page : this.helpPages) {
                    if (!page.name().equals(arg)) continue;
                    sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Displaying Help Page: " + arg));
                    for (String line : page.getHelpText()) {
                        sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.BLUE + line));
                    }
                    return;
                }
                sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "No Sub Command or Help Page exists for \"" + arg + "\"!"));
            }
        } else {
            sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Too many arguments!"));
        }
    }

    public void displayHelp(MinecraftServer server, ICommandSender sender) {
        sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + "Available commands for EnderStorage:"));
        sender.addChatMessage((ITextComponent)new TextComponentString(TextFormatting.GOLD + "For more info use \"/" + this.getCommandName() + " help [command]\""));
        for (Map.Entry entry : this.parent.getCommandMap().entrySet()) {
            String prefix = "";
            if (!((ICommand)entry.getValue()).checkPermission(server, sender)) {
                prefix = TextFormatting.RED.toString();
            }
            sender.addChatMessage((ITextComponent)new TextComponentString(prefix + "/EnderStorage " + TextFormatting.YELLOW + ((ICommand)entry.getValue()).getCommandName() + TextFormatting.BLUE + " " + HelpCommand.getCommandBrief((ICommand)entry.getValue(), sender)));
        }
        for (IHelpPage page : this.helpPages) {
            sender.addChatMessage((ITextComponent)new TextComponentString("/EnderStorage" + TextFormatting.YELLOW + " help " + page.name() + TextFormatting.BLUE + " " + page.getBrief()));
        }
    }

    private static String getCommandBrief(ICommand command, ICommandSender sender) {
        if (command instanceof ICCCommand) {
            return ((ICCCommand)command).getBrief();
        }
        return command.getCommandUsage(sender);
    }

    public HelpCommand registerHelpPage(IHelpPage page) {
        this.helpPages.add(page);
        return this;
    }

    public HelpCommand registerHelpPages() {
        this.registerHelpPage(new FrequencyHelp());
        this.registerHelpPage(new ValidStorageHelp());
        this.registerHelpPage(new ColourHelp());
        return this;
    }
}

