/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.init.ModBlocks;
import codechicken.enderstorage.init.ModItems;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.lib.inventory.InventoryUtils;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public class EnderStorageRecipe
implements IRecipe {
    public static String[] oreDictionaryNames = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public boolean matches(InventoryCrafting ic, World var2) {
        for (int row = 0; row < 2; ++row) {
            if (!this.offsetMatchesDyes(ic, 0, row)) continue;
            return true;
        }
        return false;
    }

    private boolean offsetMatchesDyes(InventoryCrafting ic, int col, int row) {
        if (!EnderStorageRecipe.stackMatches(ic.getStackInRowAndColumn(col + 1, row + 1), Item.getItemFromBlock((Block)ModBlocks.blockEnderStorage))) {
            return false;
        }
        boolean hasDye = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == row + 1 && j == col + 1) continue;
                ItemStack stack = ic.getStackInRowAndColumn(j, i);
                if (i == row && EnderStorageRecipe.getDyeType(stack) >= 0) {
                    hasDye = true;
                    continue;
                }
                if (stack == null) continue;
                return false;
            }
        }
        return hasDye;
    }

    public static boolean stackMatches(ItemStack stack, Item item) {
        return stack != null && stack.getItem() == item;
    }

    public ItemStack getCraftingResult(InventoryCrafting ic) {
        for (int row = 0; row < 2; ++row) {
            if (!this.offsetMatchesDyes(ic, 0, row)) continue;
            ItemStack freqOwner = ic.getStackInRowAndColumn(1, row + 1);
            int freq = freqOwner.getItemDamage() & 0xFFF;
            int colour1 = this.recolour(0, row, freq, ic);
            int colour2 = this.recolour(1, row, freq, ic);
            int colour3 = this.recolour(2, row, freq, ic);
            ItemStack result = InventoryUtils.copyStack((ItemStack)freqOwner, (int)1);
            result.setItemDamage(EnderStorageManager.getFreqFromColours(colour3, colour2, colour1) | freqOwner.getItemDamage() & 0xF000);
            return result;
        }
        return null;
    }

    private int recolour(int i, int row, int freq, InventoryCrafting ic) {
        int dyeType = EnderStorageRecipe.getDyeType(ic.getStackInRowAndColumn(i, row));
        if (dyeType >= 0) {
            return ~dyeType & 0xF;
        }
        return EnderStorageManager.getColourFromFreq(freq, 2 - i);
    }

    public int getRecipeSize() {
        return 6;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack((Block)ModBlocks.blockEnderStorage);
    }

    public static EnderStorageRecipe init() {
        EnderStorageRecipe instance = new EnderStorageRecipe();
        GameRegistry.addRecipe((IRecipe)instance);
        RecipeSorter.register((String)"EnderStorage:reColor", EnderStorageRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        EnderStorageRecipe.addNormalRecipes();
        return instance;
    }

    public static void removeVanillaChest() {
        Iterator iterator = CraftingManager.getInstance().getRecipeList().iterator();
        while (iterator.hasNext()) {
            ItemStack r = ((IRecipe)iterator.next()).getRecipeOutput();
            if (r == null || r.getItem() != Item.getItemFromBlock((Block)Blocks.ENDER_CHEST)) continue;
            iterator.remove();
        }
        if (!ConfigurationHandler.removeVanillaRecipe) {
            CraftingManager.getInstance().addRecipe(new ItemStack(Blocks.ENDER_CHEST), new Object[]{"OOO", "OeO", "OOO", Character.valueOf('O'), Blocks.OBSIDIAN, Character.valueOf('e'), Items.ENDER_EYE});
        }
    }

    private static void addNormalRecipes() {
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.blockEnderStorage, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"bWb", "OCO", "bpb", Character.valueOf('b'), Items.BLAZE_ROD, Character.valueOf('p'), Items.ENDER_PEARL, Character.valueOf('O'), Blocks.OBSIDIAN, Character.valueOf('C'), Blocks.CHEST, Character.valueOf('W'), new ItemStack(Blocks.WOOL, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.enderPouch, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"blb", "lpl", "bWb", Character.valueOf('b'), Items.BLAZE_POWDER, Character.valueOf('p'), Items.ENDER_PEARL, Character.valueOf('l'), Items.LEATHER, Character.valueOf('W'), new ItemStack(Blocks.WOOL, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.blockEnderStorage, 1, 0x1000 | EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[0]);
        }
    }

    public static int getDyeType(ItemStack item) {
        if (item == null) {
            return -1;
        }
        if (item.getItem() == Items.DYE) {
            return item.getItemDamage();
        }
        for (int i = 0; i < 16; ++i) {
            for (ItemStack target : OreDictionary.getOres((String)oreDictionaryNames[i])) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)item, (boolean)false)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getDyeColour(String string) {
        for (int i = 0; i < 16; ++i) {
            if (!oreDictionaryNames[i].substring(3).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public ItemStack[] getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

