/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.TankSynchroniser;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEnderTank
extends TileFrequencyOwner {
    private static Cuboid6[] selectionBoxes = new Cuboid6[4];
    public static Transformation[] buttonT = new Transformation[3];
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private boolean described;

    @Override
    public void update() {
        super.update();
        this.pressure_state.update(this.worldObj.isRemote);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.worldObj.isRemote);
    }

    private void ejectLiquid() {
        for (EnumFacing side : EnumFacing.values()) {
            int qty;
            TileEntity tile = this.worldObj.getTileEntity(this.getPos().offset(side));
            if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getOpposite())) continue;
            IFluidHandler c = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getOpposite());
            FluidStack liquid = this.getStorage().drain(100, false);
            if (liquid == null || (qty = c.fill(liquid, true)) <= 0) continue;
            this.getStorage().drain(qty, true);
        }
    }

    @Override
    public void setFreq(Frequency frequency) {
        super.setFreq(frequency);
        if (!this.worldObj.isRemote) {
            this.liquid_state.setFrequency(frequency);
        }
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return (EnderLiquidStorage)EnderStorageManager.instance(this.worldObj.isRemote).getStorage(this.frequency, "liquid");
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setByte("rot", (byte)this.rotation);
        tag.setBoolean("ir", this.pressure_state.invert_redstone);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = tag.getByte("rot");
        this.pressure_state.invert_redstone = tag.getBoolean("ir");
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.liquid_state.setFrequency(this.frequency);
        this.rotation = packet.readUByte();
        this.liquid_state.s_liquid = packet.readFluidStack();
        this.pressure_state.a_pressure = packet.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit, ItemStack stack) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtil.interactWithFluidHandler((ItemStack)stack, (IFluidHandler)this.getStorage(), (EntityPlayer)player);
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85)));
        for (int i = 0; i < 4; ++i) {
            cuboids.add(new IndexedCuboid6((Object)(i + 1), selectionBoxes[i].copy().apply(Rotation.quarterRotations[this.rotation ^ 2].at(Vector3.center))));
        }
        return cuboids;
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.amount > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.amount / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    @Override
    public boolean rotate() {
        if (!this.worldObj.isRemote) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.getUpdatePacket(), (World)this.worldObj, (int)(this.pos.getX() >> 4), (int)(this.pos.getZ() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        IFluidTankProperties tank = this.getStorage().getTankProperties()[0];
        FluidStack fluid = tank.getContents();
        if (fluid == null) {
            fluid = FluidUtils.emptyFluid();
        }
        return fluid.amount * 14 / tank.getCapacity() + (fluid.amount > 0 ? 1 : 0);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    if (((TileEnderTank)TileEnderTank.this).worldObj.isRemote) {
                        return new IFluidTankProperties[]{new FluidTankProperties(TileEnderTank.this.liquid_state.s_liquid, EnderLiquidStorage.CAPACITY)};
                    }
                    return TileEnderTank.this.getStorage().getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileEnderTank.this.getStorage().fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileEnderTank.this.getStorage().drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileEnderTank.this.getStorage().drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)i * 0.15, 0.91, 0.5));
            TileEnderTank.selectionBoxes[i] = selection_button.copy().apply(buttonT[i]);
        }
        TileEnderTank.selectionBoxes[3] = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.worldObj.isBlockPowered(TileEnderTank.this.getPos()) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 6);
            packet.writePos(TileEnderTank.this.getPos());
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk(TileEnderTank.this.worldObj, TileEnderTank.this.pos.getX() >> 4, TileEnderTank.this.pos.getZ() >> 4);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.worldObj.getChunkFromChunkCoords(TileEnderTank.this.pos.getX(), TileEnderTank.this.pos.getZ()).setChunkModified();
        }
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 5);
            packet.writePos(TileEnderTank.this.getPos());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk(TileEnderTank.this.worldObj, TileEnderTank.this.pos.getX() >> 4, TileEnderTank.this.pos.getZ() >> 4);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.worldObj.checkLight(TileEnderTank.this.pos);
        }
    }
}

