/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketTile;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.ICuboidProvider;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class TileFrequencyOwner
extends TileEntity
implements ICuboidProvider,
ITickable,
ICustomPacketTile {
    public static Cuboid6 selection_button = new Cuboid6(-0.0625, 0.0, -0.125, 0.0625, 0.0625, 0.125);
    public Frequency frequency = new Frequency();
    private int changeCount;

    public void setFreq(Frequency frequency) {
        this.frequency = frequency;
        this.markDirty();
        IBlockState state = this.worldObj.getBlockState(this.pos);
        this.worldObj.notifyBlockUpdate(this.pos, state, state, 3);
        if (!this.worldObj.isRemote) {
            this.sendUpdatePacket();
        }
    }

    public void update() {
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.worldObj.updateComparatorOutputLevel(this.pos, this.getBlockType());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract AbstractEnderStorage getStorage();

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.frequency.readNBT(tag.getCompoundTag("Frequency"));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("Frequency", (NBTBase)this.frequency.toNBT());
        return tag;
    }

    public boolean activate(EntityPlayer player, int subHit, ItemStack stack) {
        return false;
    }

    public void onPlaced(EntityLivingBase entity) {
    }

    protected void sendUpdatePacket() {
        this.writeToCCPacket().sendToChunk(this.worldObj, this.getPos().getX() >> 4, this.getPos().getZ() >> 4);
    }

    public RayTraceResult rayTrace(World world, Vec3d vec3d, Vec3d vec3d1, RayTraceResult fullBlock) {
        return fullBlock;
    }

    public PacketCustom writeToCCPacket() {
        PacketCustom packet = new PacketCustom((Object)"ES", 1);
        this.writeToPacket((MCDataOutput)packet);
        return packet;
    }

    public final SPacketUpdateTileEntity getUpdatePacket() {
        return this.writeToCCPacket().toTilePacket(this.getPos());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToCCPacket().toNBTTag(super.getUpdateTag());
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeNBTTagCompound(this.frequency.toNBT());
    }

    public void readFromPacket(MCDataInput packet) {
        this.frequency.readNBT(packet.readNBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromPacket((MCDataInput)PacketCustom.fromTilePacket((SPacketUpdateTileEntity)pkt));
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readFromPacket((MCDataInput)PacketCustom.fromNBTTag((NBTTagCompound)tag));
    }

    public int getLightValue() {
        return 0;
    }

    public boolean redstoneInteraction() {
        return false;
    }

    public int comparatorInput() {
        return 0;
    }

    public boolean rotate() {
        return false;
    }
}

