/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.EnderStorageRecipe;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.item.TileEnderChest;
import codechicken.enderstorage.storage.liquid.TileEnderTank;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEnderStorage
extends BlockContainer {
    private RayTracer rayTracer = new RayTracer();

    public BlockEnderStorage() {
        super(Material.rock);
        this.setHardness(20.0f);
        this.setResistance(100.0f);
        this.setStepSound(soundTypeStone);
        this.setCreativeTab(CreativeTabs.tabDecorations);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEnderChest();
            }
            case 1: {
                return new TileEnderTank();
            }
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition mop, World world, int x, int y, int z) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        return this.createItem(world.getBlockMetadata(x, y, z), tile.freq, tile.owner);
    }

    private ItemStack createItem(int meta, int freq, String owner) {
        ItemStack stack = new ItemStack((Block)this, 1, freq | meta << 12);
        if (!owner.equals("global")) {
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            stack.getTagCompound().setString("owner", owner);
        }
        return stack;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.harvestBlock(world, player, x, y, z, meta);
        world.setBlockToAir(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(i, j, k);
        if (tile != null) {
            ret.add(this.createItem(meta, tile.freq, tile.owner));
        }
        return ret;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack item;
        int dye;
        if (world.isRemote) {
            return true;
        }
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        if (hit == null) {
            return false;
        }
        if (hit.subHit == 4) {
            ItemStack item2 = player.inventory.getCurrentItem();
            if (player.isSneaking() && !tile.owner.equals("global")) {
                if (!player.capabilities.isCreativeMode && !player.inventory.addItemStackToInventory(EnderStorage.getPersonalItem())) {
                    return false;
                }
                tile.setOwner("global");
                return true;
            }
            if (item2 != null && item2.getItem() == EnderStorage.getPersonalItem().getItem() && tile.owner.equals("global")) {
                tile.setOwner(player.getCommandSenderName());
                if (!player.capabilities.isCreativeMode) {
                    --item2.stackSize;
                }
                return true;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && (dye = EnderStorageRecipe.getDyeType(item = player.inventory.getCurrentItem())) != -1) {
            int currentfreq = tile.freq;
            int[] colours = EnderStorageManager.getColoursFromFreq(currentfreq);
            if (colours[hit.subHit - 1] == (~dye & 0xF)) {
                return false;
            }
            colours[hit.subHit - 1] = ~dye & 0xF;
            tile.setFreq(EnderStorageManager.getFreqFromColours(colours));
            if (!player.capabilities.isCreativeMode) {
                --item.stackSize;
            }
            return true;
        }
        return tile.activate(player, hit.subHit);
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entity, ItemStack item) {
        ((TileFrequencyOwner)world.getTileEntity(i, j, k)).onPlaced(entity);
    }

    public void addCollisionBoxesToList(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.addCollisionBoxesToList(world, i, j, k, axisalignedbb, arraylist, entity);
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, World world, int x, int y, int z) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        return ForgeHooks.blockStrength((Block)(tile.invincible() ? Blocks.bedrock : this), (EntityPlayer)player, (World)world, (int)0, (int)0, (int)0);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        if (tile == null) {
            return null;
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        tile.addTraceableCuboids(cuboids);
        return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 4096));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.target.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && event.player.worldObj.getBlock(event.target.blockX, event.target.blockY, event.target.blockZ) == this) {
            RayTracer.retraceBlock((World)event.player.worldObj, (EntityPlayer)event.player, (int)event.target.blockX, (int)event.target.blockY, (int)event.target.blockZ);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        return tile.redstoneInteraction();
    }

    public IIcon getIcon(int par1, int par2) {
        return Blocks.obsidian.getIcon(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int par5) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        return tile.comparatorInput();
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileFrequencyOwner tile = (TileFrequencyOwner)world.getTileEntity(x, y, z);
        return tile.rotate();
    }
}

