/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.core.featurehack.GameDataManipulator;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.item.ItemEnderChestDummy;
import codechicken.lib.inventory.InventoryUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class EnderStorageRecipe
implements IRecipe {
    public static String[] oreDictionaryNames = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public boolean matches(InventoryCrafting inventorycrafting, World var2) {
        for (int row = 0; row <= 1; ++row) {
            if (!this.offsetMatchesDyes(inventorycrafting, 0, row)) continue;
            return true;
        }
        return false;
    }

    private boolean offsetMatchesDyes(InventoryCrafting inventorycrafting, int col, int row) {
        if (!EnderStorageRecipe.stackMatches(inventorycrafting.getStackInRowAndColumn(col + 1, row + 1), Item.getItemFromBlock((Block)EnderStorage.blockEnderChest))) {
            return false;
        }
        if (EnderStorageRecipe.getDyeType(inventorycrafting.getStackInRowAndColumn(col, row)) >= 0) {
            return true;
        }
        if (EnderStorageRecipe.getDyeType(inventorycrafting.getStackInRowAndColumn(col + 1, row)) >= 0) {
            return true;
        }
        return EnderStorageRecipe.getDyeType(inventorycrafting.getStackInRowAndColumn(col + 2, row)) >= 0;
    }

    public static boolean stackMatches(ItemStack stack, Item item) {
        return stack != null && stack.getItem() == item;
    }

    public ItemStack getCraftingResult(InventoryCrafting ic) {
        for (int row = 0; row <= 1; ++row) {
            if (!this.offsetMatchesDyes(ic, 0, row)) continue;
            ItemStack freqowner = ic.getStackInRowAndColumn(1, row + 1);
            int freq = freqowner.getItemDamage() & 0xFFF;
            int colour1 = this.recolour(0, row, freq, ic);
            int colour2 = this.recolour(1, row, freq, ic);
            int colour3 = this.recolour(2, row, freq, ic);
            ItemStack result = InventoryUtils.copyStack((ItemStack)freqowner, (int)1);
            result.setItemDamage(EnderStorageManager.getFreqFromColours(colour1, colour2, colour3) | freqowner.getItemDamage() & 0xF000);
            return result;
        }
        return null;
    }

    private int recolour(int i, int row, int freq, InventoryCrafting ic) {
        int dyeType = EnderStorageRecipe.getDyeType(ic.getStackInRowAndColumn(i, row));
        if (dyeType >= 0) {
            return ~dyeType & 0xF;
        }
        return EnderStorageManager.getColourFromFreq(freq, i);
    }

    public int getRecipeSize() {
        return 6;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack((Block)EnderStorage.blockEnderChest);
    }

    public static void init() {
        EnderStorageRecipe instance = new EnderStorageRecipe();
        GameRegistry.addRecipe((IRecipe)instance);
        EnderStorageRecipe.addNormalRecipies();
    }

    public static void removeVanillaChest() {
        GameDataManipulator.replaceItem((int)Block.getIdFromBlock((Block)Blocks.ender_chest), (Item)new ItemEnderChestDummy());
        Iterator iterator = CraftingManager.getInstance().getRecipeList().iterator();
        while (iterator.hasNext()) {
            ItemStack r = ((IRecipe)iterator.next()).getRecipeOutput();
            if (r == null || r.getItem() != Item.getItemFromBlock((Block)Blocks.ender_chest)) continue;
            iterator.remove();
        }
        if (!EnderStorage.removeVanillaRecipe) {
            CraftingManager.getInstance().addRecipe(new ItemStack(Blocks.ender_chest), new Object[]{"OOO", "OeO", "OOO", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('e'), Items.ender_eye});
        }
    }

    private static void addNormalRecipies() {
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)EnderStorage.blockEnderChest, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"bWb", "OCO", "bpb", Character.valueOf('b'), Items.blaze_rod, Character.valueOf('p'), Items.ender_pearl, Character.valueOf('O'), Blocks.obsidian, Character.valueOf('C'), Blocks.chest, Character.valueOf('W'), new ItemStack(Blocks.wool, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)EnderStorage.itemEnderPouch, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"blb", "lpl", "bWb", Character.valueOf('b'), Items.blaze_powder, Character.valueOf('p'), Items.ender_pearl, Character.valueOf('l'), Items.leather, Character.valueOf('W'), new ItemStack(Blocks.wool, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)EnderStorage.blockEnderChest, 1, 0x1000 | EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"bWb", "OCO", "bpb", Character.valueOf('b'), Items.blaze_rod, Character.valueOf('p'), Items.ender_pearl, Character.valueOf('O'), Blocks.obsidian, Character.valueOf('C'), Items.cauldron, Character.valueOf('W'), new ItemStack(Blocks.wool, 1, i)});
        }
    }

    public static int getDyeType(ItemStack item) {
        if (item == null) {
            return -1;
        }
        if (item.getItem() == Items.dye) {
            return item.getItemDamage();
        }
        for (int i = 0; i < 16; ++i) {
            for (ItemStack target : OreDictionary.getOres((String)oreDictionaryNames[i])) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)item, (boolean)false)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getDyeColour(String string) {
        for (int i = 0; i < 16; ++i) {
            if (!oreDictionaryNames[i].substring(3).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }
}

