/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class TileFrequencyOwner
extends TileEntity {
    public static Cuboid6 selection_button = new Cuboid6(-0.0625, 0.0, -0.125, 0.0625, 0.0625, 0.125);
    public int freq;
    public String owner = "global";
    private int changeCount;

    public void validate() {
        super.validate();
        if (!(this.worldObj instanceof WorldServer) == this.worldObj.isRemote) {
            this.reloadStorage();
        }
    }

    public void setFreq(int i) {
        this.freq = i;
        this.reloadStorage();
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void setOwner(String username) {
        this.owner = username;
        this.reloadStorage();
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void updateEntity() {
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract void reloadStorage();

    public abstract AbstractEnderStorage getStorage();

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.freq = tag.getInteger("freq");
        this.owner = tag.getString("owner");
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("freq", this.freq);
        tag.setString("owner", this.owner);
    }

    public boolean activate(EntityPlayer player, int subHit) {
        return false;
    }

    public void onPlaced(EntityLivingBase entity) {
    }

    public boolean invincible() {
        return false;
    }

    public MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, MovingObjectPosition fullblock) {
        return fullblock;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1))));
    }

    public final Packet getDescriptionPacket() {
        PacketCustom packet = new PacketCustom((Object)"ES", 1);
        packet.writeCoord(this.xCoord, this.yCoord, this.zCoord);
        packet.writeShort(this.freq);
        packet.writeString(this.owner);
        this.writeToPacket(packet);
        return packet.toPacket();
    }

    public void writeToPacket(PacketCustom packet) {
    }

    public void handleDescriptionPacket(PacketCustom desc) {
        this.freq = desc.readUShort();
        this.owner = desc.readString();
    }

    public int getLightValue() {
        return 0;
    }

    public boolean redstoneInteraction() {
        return false;
    }

    public int comparatorInput() {
        return 0;
    }

    public boolean rotate() {
        return false;
    }
}

