/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.ClientUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.internal.EnderStorageSPH;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.item.ContainerEnderItemStorage;
import codechicken.enderstorage.storage.item.GuiEnderItemStorage;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EnderItemStorage
extends AbstractEnderStorage
implements IInventory {
    private ItemStack[] items;
    private int open;
    private int size = EnderItemStoragePlugin.configSize;

    public EnderItemStorage(EnderStorageManager manager, String owner, int freq) {
        super(manager, owner, freq);
        this.empty();
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.size = tag.getByte("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (NBTTagList)tag.getTagList("Items", 10));
        if (this.size != EnderItemStoragePlugin.configSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderItemStoragePlugin.configSize > this.size) {
            ItemStack[] newItems = new ItemStack[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderItemStoragePlugin.configSize;
            this.markDirty();
        } else {
            int numStacks = 0;
            for (ItemStack item : this.items) {
                if (item == null) continue;
                ++numStacks;
            }
            if (numStacks <= EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]) {
                ItemStack[] newItems = new ItemStack[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
                int copyTo = 0;
                for (ItemStack item : this.items) {
                    if (item == null) continue;
                    newItems[copyTo] = item;
                    ++copyTo;
                }
                this.items = newItems;
                this.size = EnderItemStoragePlugin.configSize;
                this.markDirty();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public NBTTagCompound saveToTag() {
        if (this.size != EnderItemStoragePlugin.configSize && this.open == 0) {
            this.alignSize();
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("Items", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        compound.setByte("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getStackInSlot(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getStackInSlotOnClosing(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.getStackInSlotOnClosing((IInventory)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInventorySlotContents(int slot, ItemStack stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int getSizeInventory() {
        return EnderItemStoragePlugin.sizes[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack decrStackSize(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((IInventory)this, (int)slot, (int)size);
        }
    }

    public String getInventoryName() {
        return null;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        this.setDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void empty() {
        this.items = new ItemStack[this.getSizeInventory()];
    }

    public void openSMPGui(EntityPlayer player, final String name) {
        ServerUtils.openSMPContainer((EntityPlayerMP)((EntityPlayerMP)player), (Container)new ContainerEnderItemStorage((IInventory)player.inventory, this, false), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(EntityPlayerMP player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)"ES", 2);
                packet.writeByte(windowId);
                packet.writeString(EnderItemStorage.this.owner);
                packet.writeShort(EnderItemStorage.this.freq);
                packet.writeString(name);
                packet.writeByte(EnderItemStorage.this.size);
                packet.sendToPlayer((EntityPlayer)player);
            }
        });
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openClientGui(int windowID, InventoryPlayer playerInv, String name, int size) {
        this.size = size;
        this.empty();
        ClientUtils.openSMPGui((int)windowID, (GuiScreen)new GuiEnderItemStorage(playerInv, this, name));
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }
}

