/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.item.TileEnderChest;
import codechicken.lib.render.SpriteSheetManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemEnderPouch
extends Item {
    @SideOnly(value=Side.CLIENT)
    private SpriteSheetManager.SpriteSheet spriteSheet;

    public ItemEnderPouch() {
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setCreativeTab(CreativeTabs.tabDecorations);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        if (stack.hasTagCompound() && !stack.getTagCompound().getString("owner").equals("global")) {
            list.add(stack.getTagCompound().getString("owner"));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEnderChest && player.isSneaking()) {
            TileEnderChest chest = (TileEnderChest)tile;
            stack.setItemDamage(chest.freq);
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            stack.getTagCompound().setString("owner", chest.owner);
            return true;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack item, World world, EntityPlayer player) {
        if (world.isRemote || player.isSneaking()) {
            return item;
        }
        ((EnderItemStorage)EnderStorageManager.instance(world.isRemote).getStorage(this.getOwner(item), item.getItemDamage() & 0xFFF, "item")).openSMPGui(player, item.getUnlocalizedName() + ".name");
        return item;
    }

    public boolean func_46058_c() {
        return true;
    }

    public String getOwner(ItemStack stack) {
        return stack.hasTagCompound() ? stack.getTagCompound().getString("owner") : "global";
    }

    public int getRenderPasses(int metadata) {
        return 4;
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.spriteSheet.getSprite(this.getIconIndex(stack, renderPass));
    }

    public int getIconIndex(ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            int i = 0;
            if (((EnderItemStorage)EnderStorageManager.instance(true).getStorage(this.getOwner(stack), stack.getItemDamage() & 0xFFF, "item")).openCount() > 0) {
                i |= 1;
            }
            if (!this.getOwner(stack).equals("global")) {
                i |= 2;
            }
            return i;
        }
        return renderPass * 16 + EnderStorageManager.getColourFromFreq(stack.getItemDamage() & 0xFFF, renderPass - 1);
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public void registerIcons(IIconRegister register) {
        this.spriteSheet = SpriteSheetManager.getSheet((ResourceLocation)new ResourceLocation("enderstorage", "textures/enderpouch.png"));
        this.spriteSheet.requestIndicies(new int[]{0, 1, 2, 3});
        int i = 16;
        while (i < 64) {
            this.spriteSheet.requestIndicies(new int[]{i++});
        }
        this.spriteSheet.registerIcons(register);
    }
}

