/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.item.EnderDyeButton;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.item.EnderKnobSlot;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEnderChest
extends TileFrequencyOwner
implements IInventory {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    private EnderItemStorage storage;
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    public TileEnderChest(World world, int metaData) {
        this.worldObj = world;
        this.freq = metaData;
        this.c_numOpen = -1;
    }

    public TileEnderChest() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) != 0) {
            this.rotation = this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 3);
        }
        if (!(this.worldObj.isRemote || this.worldObj.getTotalWorldTime() % 20L != 0L && this.c_numOpen == this.storage.getNumOpen())) {
            this.c_numOpen = this.storage.getNumOpen();
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, (Block)EnderStorage.blockEnderChest, 1, this.c_numOpen);
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean receiveClientEvent(int i, int j) {
        if (i == 1) {
            this.c_numOpen = j;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderItemStorage)EnderStorageManager.instance(this.worldObj.isRemote).getStorage(this.owner, this.freq, "item");
    }

    @Override
    public EnderItemStorage getStorage() {
        return this.storage;
    }

    public int getSizeInventory() {
        return this.storage.getSizeInventory();
    }

    public ItemStack getStackInSlot(int var1) {
        return this.storage.getStackInSlot(var1);
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return this.storage.decrStackSize(var1, var2);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.storage.getStackInSlotOnClosing(var1);
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.storage.setInventorySlotContents(var1, var2);
    }

    public String getInventoryName() {
        return "Ender Chest";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setByte("rot", (byte)this.rotation);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.getByte("rot");
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        this.storage.openSMPGui(player, "tile.enderchest|0.name");
        return true;
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6((double)this.xCoord + 0.0625, (double)this.yCoord, (double)this.zCoord + 0.0625, (double)this.xCoord + 0.9375, (double)this.yCoord + 0.875, (double)this.zCoord + 0.9375)));
        if (this.getRadianLidAngle(0.0f) < 0.0) {
            return;
        }
        for (int button = 0; button < 3; ++button) {
            EnderDyeButton ebutton = buttons[button].copy();
            ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, 0.0);
            ebutton.rotateMeta(this.rotation);
            cuboids.add(new IndexedCuboid6((Object)(button + 1), new Cuboid6(ebutton.getMin(), ebutton.getMax()).add(Vector3.fromTileEntity((TileEntity)this))));
        }
        cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(this.rotation).getSelectionBB()).add(Vector3.fromTileEntity((TileEntity)this))));
    }

    @Override
    public boolean rotate() {
        if (!this.worldObj.isRemote) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.getDescriptionPacket(), (World)this.worldObj, (int)(this.xCoord >> 4), (int)(this.zCoord >> 4));
        }
        return true;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    @Override
    public int comparatorInput() {
        return Container.calcRedstoneFromInventory((IInventory)this);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
        }
    }
}

