/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEnderTank
extends TileFrequencyOwner
implements IFluidHandler {
    private static Cuboid6[] selectionBoxes = new Cuboid6[4];
    public static Transformation[] buttonT = new Transformation[3];
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private EnderLiquidStorage storage;
    private boolean described;

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.pressure_state.update(this.worldObj.isRemote);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.worldObj.isRemote);
    }

    private void ejectLiquid() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int qty;
            TileEntity t = this.worldObj.getTileEntity(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ);
            if (!(t instanceof IFluidHandler)) continue;
            IFluidHandler c = (IFluidHandler)t;
            FluidStack liquid = this.drain(null, 100, false);
            if (liquid == null || (qty = c.fill(side.getOpposite(), liquid, true)) <= 0) continue;
            this.drain(null, qty, true);
        }
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderLiquidStorage)EnderStorageManager.instance(this.worldObj.isRemote).getStorage(this.owner, this.freq, "liquid");
        if (!this.worldObj.isRemote) {
            this.liquid_state.reloadStorage(this.storage);
        }
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return this.storage;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storage.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storage.drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.storage.drain(from, resource, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.storage.canDrain(from, fluid);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.storage.canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.storage.getTankInfo(from);
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setByte("rot", (byte)this.rotation);
        tag.setBoolean("ir", this.pressure_state.invert_redstone);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.getByte("rot");
        this.pressure_state.invert_redstone = tag.getBoolean("ir");
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
        this.liquid_state.s_liquid = desc.readFluidStack();
        this.pressure_state.a_pressure = desc.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtils.fillTankWithContainer((IFluidHandler)this, (EntityPlayer)player) || FluidUtils.emptyTankIntoContainer((IFluidHandler)this, (EntityPlayer)player, (FluidStack)this.storage.getFluid());
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        Vector3 pos = new Vector3((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85).add(pos)));
        for (int i = 0; i < 4; ++i) {
            cuboids.add(new IndexedCuboid6((Object)(i + 1), selectionBoxes[i].copy().apply(Rotation.quarterRotations[this.rotation ^ 2].at(Vector3.center)).add(pos)));
        }
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.amount > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.amount / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    @Override
    public boolean rotate() {
        if (!this.worldObj.isRemote) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.getDescriptionPacket(), (World)this.worldObj, (int)(this.xCoord >> 4), (int)(this.zCoord >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        FluidTankInfo tank = this.storage.getTankInfo(null)[0];
        return tank.fluid.amount * 14 / tank.capacity + (tank.fluid.amount > 0 ? 1 : 0);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)i * 0.15, 0.91, 0.5));
            TileEnderTank.selectionBoxes[i] = selection_button.copy().apply(buttonT[i]);
        }
        TileEnderTank.selectionBoxes[3] = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                boolean bl = this.a_pressure = TileEnderTank.this.worldObj.isBlockIndirectlyGettingPowered(TileEnderTank.this.xCoord, TileEnderTank.this.yCoord, TileEnderTank.this.zCoord) != this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90.0 : 90.0;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 6);
            packet.writeCoord(TileEnderTank.this.xCoord, TileEnderTank.this.yCoord, TileEnderTank.this.zCoord);
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk(TileEnderTank.this.worldObj, TileEnderTank.this.xCoord >> 4, TileEnderTank.this.zCoord >> 4);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.worldObj.getChunkFromBlockCoords(TileEnderTank.this.xCoord, TileEnderTank.this.zCoord).setChunkModified();
        }
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 5);
            packet.writeCoord(TileEnderTank.this.xCoord, TileEnderTank.this.yCoord, TileEnderTank.this.zCoord);
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk(TileEnderTank.this.worldObj, TileEnderTank.this.xCoord >> 4, TileEnderTank.this.zCoord >> 4);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.worldObj.func_147451_t(TileEnderTank.this.xCoord, TileEnderTank.this.yCoord, TileEnderTank.this.zCoord);
        }
    }
}

