/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.BlockMultipart$;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.TileMultipartClient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.runtime.BoxedUnit;

@SideOnly(value=Side.CLIENT)
public final class MultipartRenderer$
extends TileEntitySpecialRenderer<TileMultipartClient>
implements ICCBlockRenderer {
    public static final MultipartRenderer$ MODULE$;
    private final EnumBlockRenderType renderType;

    static {
        new MultipartRenderer$();
    }

    public EnumBlockRenderType renderType() {
        return this.renderType;
    }

    public void register() {
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)this.renderType(), (ICCBlockRenderer)this);
    }

    public void renderTileEntityAt(TileMultipartClient tile, double x, double y, double z, float frame, int destroyStage) {
        if (((TileMultipart)((Object)tile)).partList().isEmpty()) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        tile.renderDynamic(new Vector3(x, y, z), MinecraftForgeClient.getRenderPass(), frame);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        GlStateManager.shadeModel((int)(Minecraft.isAmbientOcclusionEnabled() ? 7425 : 7424));
        RenderHelper.disableStandardItemLighting();
        TextureUtils.bindBlockTexture();
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.BLOCK);
        tile.renderFast(new Vector3(x, y, z), MinecraftForgeClient.getRenderPass(), frame, ccrs);
        ccrs.getBuffer().setTranslation(0.0, 0.0, 0.0);
        ccrs.draw();
        RenderHelper.enableStandardItemLighting();
    }

    public void renderTileEntityFast(TileMultipartClient tile, double x, double y, double z, float frame, int destroyStage, VertexBuffer buffer) {
        if (((TileMultipart)((Object)tile)).partList().isEmpty()) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(buffer);
        tile.renderFast(new Vector3(x, y, z), MinecraftForgeClient.getRenderPass(), frame, ccrs);
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, VertexBuffer buffer) {
        boolean bl;
        TileMultipartClient tileMultipartClient = BlockMultipart$.MODULE$.getClientTile(world, pos);
        if (tileMultipartClient == null) {
            bl = false;
        } else {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind(buffer);
            ccrs.lightMatrix.locate(world, pos);
            bl = tileMultipartClient.renderStatic(Vector3.fromBlockPos((BlockPos)pos), MinecraftForgeClient.getRenderLayer(), ccrs);
        }
        return bl;
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, VertexBuffer buffer) {
        TileMultipartClient tileMultipartClient = BlockMultipart$.MODULE$.getClientTile(world, pos);
        if (tileMultipartClient == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind(buffer);
            tileMultipartClient.renderDamage(Vector3.fromBlockPos((BlockPos)pos), sprite, ccrs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void registerTextures(TextureMap map) {
    }

    private MultipartRenderer$() {
        MODULE$ = this;
        this.renderType = BlockRenderingRegistry.createRenderType((String)"fmpcbe_mpblock");
    }
}

