/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry$;
import codechicken.multipart.MultipartGenerator$;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileCache$;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartCompatiblity$;
import codechicken.multipart.handler.MultipartProxy$;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TileMultipart$ {
    public static final TileMultipart$ MODULE$;

    static {
        new TileMultipart$();
    }

    public TileMultipart getOrConvertTile(World world, BlockPos pos) {
        return (TileMultipart)((Object)this.getOrConvertTile2(world, pos)._1());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<TileMultipart, Object> getOrConvertTile2(World world, BlockPos pos) {
        void var4_4;
        TileEntity t = world.getTileEntity(pos);
        if (t instanceof TileMultipart) {
            return new Tuple2((Object)((TileMultipart)t), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        TMultiPart p = MultiPartRegistry$.MODULE$.convertBlock(world, pos, world.getBlockState(pos).getBlock());
        if (p == null) {
            return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        TileMultipart t2 = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Iterable<TMultiPart>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TMultiPart[]{var4_4}))), world.isRemote);
        t2.setPos(pos);
        t2.setWorldObj(world);
        t2.addPart_do((TMultiPart)var4_4);
        return new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public TileMultipart getTile(World world, BlockPos pos) {
        TileMultipart tileMultipart;
        TileEntity tileEntity = world.getTileEntity(pos);
        TileMultipart tileMultipart2 = tileEntity instanceof TileMultipart ? (tileMultipart = (TileMultipart)tileEntity) : null;
        return tileMultipart2;
    }

    public boolean checkNoEntityCollision(World world, BlockPos pos, TMultiPart part) {
        return JavaConversions$.MODULE$.iterableAsScalaIterable(part.getCollisionBoxes()).forall((Function1)new Serializable(world, pos){
            private final World world$1;
            private final BlockPos pos$2;

            public final boolean apply(Cuboid6 b) {
                return this.world$1.checkNoEntityCollision(b.aabb().offset(this.pos$2));
            }
            {
                this.world$1 = world$1;
                this.pos$2 = pos$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean canPlacePart(World world, BlockPos pos, TMultiPart part) {
        if (this.checkNoEntityCollision(world, pos, part)) {
            void var4_4;
            TileMultipart t = this.getOrConvertTile(world, pos);
            if (t == null) {
                if (BoxesRunTime.unboxToBoolean((Object)MultipartCompatiblity$.MODULE$.canAddPart().apply((Object)world, (Object)pos))) {
                    return this.replaceable(world, pos);
                }
                return false;
            }
            return var4_4.canAddPart(part);
        }
        return false;
    }

    public boolean replaceable(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        return block.isAir(state, (IBlockAccess)world, pos) || block.isReplaceable((IBlockAccess)world, pos);
    }

    public TileMultipart addPart(World world, BlockPos pos, TMultiPart part) {
        Predef$.MODULE$.assert(!world.isRemote, (Function0)new Serializable(){

            public final String apply() {
                return "Cannot add multi parts to a client tile.";
            }
        });
        return MultipartGenerator$.MODULE$.addPart(world, pos, part);
    }

    public void handleDescPacket(World world, BlockPos pos, PacketCustom packet) {
        TileMultipart tilemp;
        short nparts = packet.readUByte();
        ListBuffer parts = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)nparts).foreach((Function1)new Serializable(packet, parts){
            private final PacketCustom packet$2;
            private final ListBuffer parts$2;

            public final ListBuffer<TMultiPart> apply(int i) {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)this.packet$2);
                part.readDesc((MCDataInput)this.packet$2);
                return this.parts$2.$plus$eq((Object)part);
            }
            {
                this.packet$2 = packet$2;
                this.parts$2 = parts$2;
            }
        });
        if (parts.isEmpty()) {
            return;
        }
        TileEntity t = world.getTileEntity(pos);
        TileMultipart tileMultipart = tilemp = MultipartGenerator$.MODULE$.generateCompositeTile(t, (Iterable<TMultiPart>)parts, true);
        TileEntity tileEntity = t;
        if (tileMultipart == null ? tileEntity != null : !((Object)((Object)tileMultipart)).equals(tileEntity)) {
            world.setBlockState(pos, MultipartProxy$.MODULE$.block().getDefaultState());
            MultipartGenerator$.MODULE$.silentAddTile(world, pos, tilemp);
        }
        tilemp.loadParts((Iterable<TMultiPart>)parts);
        tilemp.notifyTileChange();
        tilemp.markRender();
    }

    public void handlePacket(BlockPos pos, World world, int i, PacketCustom packet) {
        int n = i;
        switch (n) {
            default: {
                ((TMultiPart)this.tilemp$1(pos, world).partList().apply(i)).read((MCDataInput)packet);
                break;
            }
            case 254: {
                this.tilemp$1(pos, world).remPart_impl((TMultiPart)this.tilemp$1(pos, world).partList().apply((int)packet.readUByte()));
                break;
            }
            case 253: {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)packet);
                part.readDesc((MCDataInput)packet);
                MultipartGenerator$.MODULE$.addPart(world, pos, part);
            }
        }
    }

    public TileMultipart createFromNBT(NBTTagCompound tag) {
        NBTTagList partList = tag.getTagList("parts", 10);
        ListBuffer parts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partList.tagCount()).foreach((Function1)new Serializable(partList, parts){
            private final NBTTagList partList$1;
            private final ListBuffer parts$3;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                NBTTagCompound partTag = this.partList$1.getCompoundTagAt(i);
                String partID = partTag.getString("id");
                TMultiPart part = MultiPartRegistry$.MODULE$.loadPart(partID, partTag);
                if (part == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    part.load(partTag);
                    boxedUnit = this.parts$3.$plus$eq((Object)part);
                }
                return boxedUnit;
            }
            {
                this.partList$1 = partList$1;
                this.parts$3 = parts$3;
            }
        });
        if (parts.isEmpty()) {
            return null;
        }
        TileMultipart tmb = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Iterable<TMultiPart>)parts, false);
        tmb.readFromNBT(tag);
        tmb.loadParts((Iterable<TMultiPart>)parts);
        return tmb;
    }

    public void dropItem(ItemStack stack, World world, Vector3 pos) {
        EntityItem item = new EntityItem(world, pos.x, pos.y, pos.z, stack);
        item.motionX = world.rand.nextGaussian() * 0.05;
        item.motionY = world.rand.nextGaussian() * 0.05 + 0.2;
        item.motionZ = world.rand.nextGaussian() * 0.05;
        item.setPickupDelay(10);
        world.spawnEntityInWorld((Entity)item);
    }

    private final TileMultipart tilemp$1(BlockPos pos$3, World world$2) {
        return TileCache$.MODULE$.findTile(world$2, pos$3);
    }

    private TileMultipart$() {
        MODULE$ = this;
    }
}

