/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ButtonPart
extends McSidedMetaPart
implements IFaceRedstonePart {
    public static BlockButton stoneButton = (BlockButton)Blocks.STONE_BUTTON;
    public static BlockButton woodenButton = (BlockButton)Blocks.WOODEN_BUTTON;

    public ButtonPart() {
        this.state = stoneButton.getDefaultState();
    }

    public ButtonPart(IBlockState state) {
        super(state);
    }

    @Override
    public String getType() {
        return "mc_button";
    }

    @Override
    public byte getMeta() {
        int m = this.getBlock().getMetaFromState(this.state);
        if (this.sensitive()) {
            m |= 0x80;
        }
        return (byte)m;
    }

    @Override
    public void setMeta(byte meta) {
        this.state = ((meta & 0x80) != 0 ? woodenButton : stoneButton).getStateFromMeta(meta & 0x7F);
    }

    @Override
    public Block getBlock() {
        return this.sensitive() ? woodenButton : stoneButton;
    }

    @Override
    public int getSideFromState() {
        return ((EnumFacing)this.state.getValue((IProperty)BlockButton.FACING)).getOpposite().ordinal();
    }

    public int delay() {
        return this.sensitive() ? 30 : 20;
    }

    public boolean sensitive() {
        return this.state.getBlock() == woodenButton;
    }

    @Override
    public void setStateOnPlacement(World world, BlockPos pos, EnumFacing facing, Vec3d hitVec, EntityLivingBase placer, ItemStack held) {
        Block heldBlock = Block.getBlockFromItem((Item)held.getItem());
        if (!(heldBlock instanceof BlockButton)) {
            throw new RuntimeException("Invalid placement of Button Part");
        }
        this.state = heldBlock.onBlockPlaced(world, pos, facing, (float)hitVec.xCoord, (float)hitVec.yCoord, (float)hitVec.zCoord, 0, placer);
    }

    @Override
    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        if (this.pressed()) {
            return false;
        }
        if (!this.world().isRemote) {
            this.toggle();
        }
        return true;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (Boolean)this.state.getValue((IProperty)BlockButton.POWERED);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.world().isRemote && entity instanceof EntityArrow) {
            this.updateState();
        }
    }

    private void toggle() {
        this.state = this.state.cycleProperty((IProperty)BlockButton.POWERED);
        boolean on = this.pressed();
        SoundEvent sound = this.sensitive() ? (on ? SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON : SoundEvents.BLOCK_WOOD_BUTTON_CLICK_OFF) : (on ? SoundEvents.BLOCK_STONE_BUTTON_CLICK_ON : SoundEvents.BLOCK_STONE_BUTTON_CLICK_OFF);
        this.world().playSound(null, this.pos(), sound, SoundCategory.BLOCKS, 0.3f, on ? 0.6f : 0.5f);
        if (on) {
            this.scheduleTick(this.delay());
        }
        this.sendDescUpdate();
        this.tile().markDirty();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSideFromState());
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.sensitive() && !this.world().getEntitiesWithinAABB(EntityArrow.class, this.getBounds().add(this.pos()).aabb()).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(this.getSideFromState());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == this.getSideFromState() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSideFromState();
    }
}

