/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.IPartConverter;
import codechicken.multipart.IPartFactory;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Content
implements IPartFactory,
IPartConverter {
    @Override
    public TMultiPart createPart(String name, boolean client) {
        if (name.equals("mc_torch")) {
            return new TorchPart();
        }
        if (name.equals("mc_lever")) {
            return new LeverPart();
        }
        if (name.equals("mc_button")) {
            return new ButtonPart();
        }
        if (name.equals("mc_redtorch")) {
            return new RedstoneTorchPart();
        }
        return null;
    }

    public void init() {
        MultiPartRegistry.registerConverter(this);
        MultiPartRegistry.registerParts(this, new String[]{"mc_torch", "mc_lever", "mc_button", "mc_redtorch"});
    }

    @Override
    public Iterable<Block> blockTypes() {
        return Arrays.asList(Blocks.TORCH, Blocks.LEVER, Blocks.STONE_BUTTON, Blocks.WOODEN_BUTTON, Blocks.REDSTONE_TORCH, Blocks.UNLIT_REDSTONE_TORCH);
    }

    @Override
    public TMultiPart convert(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block b = state.getBlock();
        if (b == Blocks.TORCH) {
            return new TorchPart(state);
        }
        if (b == Blocks.LEVER) {
            return new LeverPart(state);
        }
        if (b == Blocks.STONE_BUTTON || b == Blocks.WOODEN_BUTTON) {
            return new ButtonPart(state);
        }
        if (b == Blocks.REDSTONE_TORCH || b == Blocks.UNLIT_REDSTONE_TORCH) {
            return new RedstoneTorchPart(state);
        }
        return null;
    }
}

