/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.data.MCDataOutputWrapper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import codechicken.multipart.MultiPartRegistry$;
import codechicken.multipart.MultipartGenerator$;
import codechicken.multipart.PartRayTraceResult;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileCache$;
import codechicken.multipart.TileMultipart$;
import codechicken.multipart.handler.MultipartCompatiblity$;
import codechicken.multipart.handler.MultipartProxy$;
import codechicken.multipart.handler.MultipartSPH;
import codechicken.multipart.handler.MultipartSPH$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011Ua\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002V5mK6+H\u000e^5qCJ$(BA\u0002\u0005\u0003%iW\u000f\u001c;ja\u0006\u0014HOC\u0001\u0006\u0003-\u0019w\u000eZ3dQ&\u001c7.\u001a8\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011A\u0003;jY\u0016,g\u000e^5us*\u0011QBD\u0001\n[&tWm\u0019:bMRT\u0011aD\u0001\u0004]\u0016$\u0018BA\t\u000b\u0005)!\u0016\u000e\\3F]RLG/\u001f\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tQa^8sY\u0012T!a\u0006\u0003\u0002\u00071L'-\u0003\u0002\u001a)\tq\u0011j\u00115v].du.\u00193US2,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003\u00011A\u0005\u0002\u0005\n\u0001\u0002]1si2K7\u000f^\u000b\u0002EA\u00191\u0005\u000b\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\u0015\r|G\u000e\\3di&|gNC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tICEA\u0002TKF\u0004\"AH\u0016\n\u00051\u0012!A\u0003+Nk2$\u0018\u000eU1si\"9a\u0006\u0001a\u0001\n\u0003y\u0013\u0001\u00049beRd\u0015n\u001d;`I\u0015\fHC\u0001\u00195!\t\t$'D\u0001'\u0013\t\u0019dE\u0001\u0003V]&$\bbB\u001b.\u0003\u0003\u0005\rAI\u0001\u0004q\u0012\n\u0004BB\u001c\u0001A\u0003&!%A\u0005qCJ$H*[:uA!)\u0011\b\u0001C\u0001u\u0005I!\u000eU1si2K7\u000f^\u000b\u0002wA\u0019A(\u0011\u0016\u000e\u0003uR!AP \u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0003MSN$\bB\u0002#\u0001\t\u0003\u0011Q)\u0001\u0003ge>lGC\u0001\u0019G\u0011\u001595\t1\u0001\u001e\u0003\u0011!\b.\u0019;\t\u000b%\u0003A\u0011\u0001&\u0002\u0011\r|\u0007/\u001f$s_6$\"\u0001M&\t\u000b\u001dC\u0005\u0019A\u000f\t\u000b5\u0003A\u0011\u0001(\u0002\u00111|\u0017\r\u001a$s_6$\"\u0001M(\t\u000b\u001dc\u0005\u0019A\u000f\t\u000bE\u0003A\u0011\u0001*\u0002\r1|\u0017\r\u001a+p)\t\u00014\u000bC\u0003H!\u0002\u0007Q\u0004C\u0003V\u0001\u0011\u0005a+\u0001\u0006dY\u0016\f'\u000fU1siN$\u0012\u0001\r\u0005\u00061\u0002!\t!W\u0001\tE&tG\rU1siR\u0011\u0001G\u0017\u0005\u00067^\u0003\rAK\u0001\u0005a\u0006\u0014H\u000fC\u0003^\u0001\u0011\u0005a,A\u0005qCJ$\u0018\t\u001a3fIR\u0011\u0001g\u0018\u0005\u00067r\u0003\rA\u000b\u0005\u0006C\u0002!\tAY\u0001\fa\u0006\u0014HOU3n_Z,G\rF\u00021G\u0012DQa\u00171A\u0002)BQ!\u001a1A\u0002\u0019\f\u0011\u0001\u001d\t\u0003c\u001dL!\u0001\u001b\u0014\u0003\u0007%sG\u000fC\u0003k\u0001\u0011\u00051.\u0001\bhKR<V-Y6DQ\u0006tw-Z:\u0016\u00031\u0004\"!M7\n\u000594#a\u0002\"p_2,\u0017M\u001c\u0005\u0006a\u0002!\t!]\u0001\u0015_:tU-[4iE>\u0014H+\u001b7f\u0007\"\fgnZ3\u0015\u0005A\u0012\b\"B:p\u0001\u0004!\u0018a\u00038fS\u001eD'm\u001c:Q_N\u0004\"!^=\u000e\u0003YT!a\u001e=\u0002\t5\fG\u000f\u001b\u0006\u0003}1I!A\u001f<\u0003\u0011\tcwnY6Q_NDQ\u0001 \u0001\u0005\u0002u\fq\u0001]1si6\u000b\u0007\u000f\u0006\u0002+}\")qp\u001fa\u0001M\u0006!1\u000f\\8u\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tqa\u001c9fe\u0006$X\rF\u00021\u0003\u000fA\u0001\"!\u0003\u0002\u0002\u0001\u0007\u00111B\u0001\u0002MB)\u0011'!\u0004+a%\u0019\u0011q\u0002\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA\n\u0001\u0011\u0015\u0013QC\u0001\u000boJLG/\u001a+p\u001d\n#F\u0003BA\f\u0003G\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0011a\u00018ci&!\u0011\u0011EA\u000e\u00059q%\t\u0016+bO\u000e{W\u000e]8v]\u0012D\u0001\"!\n\u0002\u0012\u0001\u0007\u0011qC\u0001\u0004i\u0006<\u0007bBA\u0015\u0001\u0011\u0005\u00111F\u0001\noJLG/\u001a#fg\u000e$2\u0001MA\u0017\u0011!\ty#a\nA\u0002\u0005E\u0012A\u00029bG.,G\u000f\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9DF\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002<\u0005U\"\u0001D'D\t\u0006$\u0018mT;uaV$\bbBA \u0001\u0011\u0005\u0011\u0011I\u0001\u000fO\u0016$xK]5uKN#(/Z1n)\u0011\t\t$a\u0011\t\rm\u000bi\u00041\u0001+\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u000f*\"!!\u0013\u0011\t\u0005-\u0013q\u000b\b\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u0002\u0002\u000f!\fg\u000e\u001a7fe&!\u0011QKA(\u00031iU\u000f\u001c;ja\u0006\u0014Ho\u0015)I\u0013\u0011\tI&a\u0017\u0003\u00195\u001b%)\u001f;f'R\u0014X-Y7\u000b\t\u0005U\u0013q\n\u0005\b\u0003?\u0002A\u0011AA1\u0003)\u0019\u0017M\\!eIB\u000b'\u000f\u001e\u000b\u0004Y\u0006\r\u0004BB.\u0002^\u0001\u0007!\u0006C\u0004\u0002h\u0001!\t!!\u001b\u0002\u001d\r\fgNU3qY\u0006\u001cW\rU1siR)A.a\u001b\u0002p!9\u0011QNA3\u0001\u0004Q\u0013!B8qCJ$\bbBA9\u0003K\u0002\rAK\u0001\u0006]B\f'\u000f\u001e\u0005\b\u0003k\u0002A\u0011AA<\u00035y7m\u00197vg&|g\u000eV3tiR)A.!\u001f\u0002\u0014\"A\u00111PA:\u0001\u0004\ti(A\u0003qCJ$8\u000fE\u0003\u0002\u0000\u0005=%F\u0004\u0003\u0002\u0002\u0006-e\u0002BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001de!\u0001\u0004=e>|GOP\u0005\u0002O%\u0019\u0011Q\u0012\u0014\u0002\u000fA\f7m[1hK&\u0019\u0011&!%\u000b\u0007\u00055e\u0005C\u0004\u0002r\u0005M\u0004\u0019\u0001\u0016\t\u0011\u0005]\u0005\u0001\"\u0001\u0003\u00033\u000bA\"\u00193e!\u0006\u0014HoX5na2$2\u0001MAN\u0011\u0019Y\u0016Q\u0013a\u0001U!A\u0011q\u0014\u0001\u0005\u0002\t\t\t+\u0001\u0007xe&$X-\u00113e!\u0006\u0014H\u000fF\u00021\u0003GCaaWAO\u0001\u0004Q\u0003\u0002CAT\u0001\u0011\u0005!!!+\u0002\u0015\u0005$G\rU1si~#w\u000eF\u00021\u0003WCaaWAS\u0001\u0004Q\u0003bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\be\u0016l\u0007+\u0019:u)\ri\u00121\u0017\u0005\u00077\u00065\u0006\u0019\u0001\u0016\t\u0011\u0005]\u0006\u0001\"\u0001\u0003\u0003s\u000bAB]3n!\u0006\u0014HoX5na2$2!HA^\u0011\u0019Y\u0016Q\u0017a\u0001U!9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0017A\u0003:f[B\u000b'\u000f^0e_R)a-a1\u0002F\"11,!0A\u0002)Bq!a2\u0002>\u0002\u0007A.\u0001\u0006tK:$\u0007+Y2lKRD\u0001\"a3\u0001\t\u0003\u0011\u0011QZ\u0001\nY>\fG\rU1siN$2\u0001MAh\u0011!\tY(!3A\u0002\u0005E\u0007#BA@\u0003'T\u0013\u0002BAk\u0003#\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u00033\u0004AQAAn\u0003!\u0019X\r\u001e,bY&$Gc\u0001\u0019\u0002^\"9\u0011q\\Al\u0001\u0004a\u0017!\u00012\t\r\u0005\r\b\u0001\"\u0011W\u0003)IgN^1mS\u0012\fG/\u001a\u0005\u0007\u0003O\u0004A\u0011\t,\u0002\u0011Y\fG.\u001b3bi\u0016Dq!a;\u0001\t\u0003\ti/A\u000bbI\u0012\u001cu\u000e\u001c7jg&|gNQ8y)>d\u0015n\u001d;\u0015\u000bA\ny/!?\t\u0011\u0005E\u0018\u0011\u001ea\u0001\u0003g\f\u0011\"\u001a8uSRL(i\u001c=\u0011\u0007U\f)0C\u0002\u0002xZ\u0014Q\"\u0011=jg\u0006c\u0017n\u001a8fI\n\u0013\u0005\u0002CA~\u0003S\u0004\r!!@\u0002\t1L7\u000f\u001e\t\u0005y\u0005\u000b\u0019\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\u0002#\r|G\u000e\\5tS>t'+Y=Ue\u0006\u001cW\r\u0006\u0004\u0003\u0006\t-!Q\u0003\t\u0004=\t\u001d\u0011b\u0001B\u0005\u0005\t\u0011\u0002+\u0019:u%\u0006LHK]1dKJ+7/\u001e7u\u0011!\u0011i!a@A\u0002\t=\u0011!B:uCJ$\bcA;\u0003\u0012%\u0019!1\u0003<\u0003\u000bY+7m\r3\t\u0011\t]\u0011q a\u0001\u0005\u001f\t1!\u001a8e\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;\t1B]1z)J\f7-Z!mYR1!q\u0004B\u0015\u0005W\u0001bA!\t\u0003(\t\u0015QB\u0001B\u0012\u0015\r\u0011)cP\u0001\u0005Y\u0006tw-\u0003\u0003\u0002V\n\r\u0002\u0002\u0003B\u0007\u00053\u0001\rAa\u0004\t\u0011\t]!\u0011\u0004a\u0001\u0005\u001fAqAa\f\u0001\t\u0003\u0011\t$A\u0006iCJ4Xm\u001d;QCJ$H#\u0002\u0019\u00034\t]\u0002\u0002\u0003B\u001b\u0005[\u0001\rA!\u0002\u0002\u0007!LG\u000f\u0003\u0005\u0003:\t5\u0002\u0019\u0001B\u001e\u0003\u0019\u0001H.Y=feB!!Q\bB#\u001b\t\u0011yD\u0003\u0003\u0003:\t\u0005#b\u0001B\"\u0019\u00051QM\u001c;jifLAAa\u0012\u0003@\taQI\u001c;jif\u0004F.Y=fe\"9!1\n\u0001\u0005\u0002\t5\u0013\u0001C4fi\u0012\u0013x\u000e]:\u0016\u0005\t=\u0003#\u0002\u001f\u0003R\tU\u0013b\u0001B*{\tI\u0011I\u001d:bs2K7\u000f\u001e\t\u0005\u0005/\u0012i&\u0004\u0002\u0003Z)\u0019!1\f\u0007\u0002\t%$X-\\\u0005\u0005\u0005?\u0012IFA\u0005Ji\u0016l7\u000b^1dW\"9!1\r\u0001\u0005\u0002\t\u0015\u0014\u0001D4fiBK7m\u001b\"m_\u000e\\G\u0003\u0002B+\u0005OB\u0001B!\u000e\u0003b\u0001\u0007!Q\u0001\u0005\b\u0005W\u0002A\u0011\u0001B7\u0003\u001dI7oU8mS\u0012$2\u0001\u001cB8\u0011\u001d\u0011\tH!\u001bA\u0002\u0019\fAa]5eK\"1!Q\u000f\u0001\u0005\u0002-\f!cY1o!2\f7-\u001a+pe\u000eDwJ\u001c+pa\"9!\u0011\u0010\u0001\u0005\u0002\tm\u0014AF4fi\u0016C\b\u000f\\8tS>t'+Z:jgR\fgnY3\u0015\t\tu$1\u0011\t\u0004c\t}\u0014b\u0001BAM\t)a\t\\8bi\"A!1\tB<\u0001\u0004\u0011)\t\u0005\u0003\u0003\b\n%UB\u0001B!\u0013\u0011\u0011YI!\u0011\u0003\r\u0015sG/\u001b;z\u0011\u001d\u0011y\t\u0001C\u0001\u0005#\u000bQbZ3u\u0019&<\u0007\u000e\u001e,bYV,W#\u00014\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0018\u0006qr-\u001a;QY\u0006LXM\u001d*fY\u0006$\u0018N^3CY>\u001c7\u000eS1sI:,7o\u001d\u000b\u0007\u0005{\u0012IJa'\t\u0011\te\"1\u0013a\u0001\u0005wA\u0001B!\u000e\u0003\u0014\u0002\u0007!Q\u0001\u0005\u0007\u0005?\u0003A\u0011\t,\u0002\u001b=t7\t[;oWVsGn\\1e\u0011\u0019\u0011\u0019\u000b\u0001C!-\u0006YqN\\\"ik:\\Gj\\1e\u0011\u001d\u00119\u000b\u0001C!\u0005S\u000bab]3u/>\u0014H\u000eZ\"sK\u0006$X\rF\u00021\u0005WC\u0001B!,\u0003&\u0002\u0007!qV\u0001\bo>\u0014H\u000eZ%o!\u0011\u0011\tL!.\u000e\u0005\tM&BA\u000b\r\u0013\u0011\u00119La-\u0003\u000b]{'\u000f\u001c3\t\r\tm\u0006\u0001\"\u0001W\u0003\u001dyg.T8wK\u0012DqAa0\u0001\t\u0003\u0011\t-\u0001\tp]\ncwnY6BGRLg/\u0019;fIR9ANa1\u0003F\n\u001d\u0007\u0002\u0003B\u001d\u0005{\u0003\rAa\u000f\t\u0011\tU\"Q\u0018a\u0001\u0005\u000bA\u0001B!3\u0003>\u0002\u0007!1Z\u0001\u0005Q\u0006tG\r\u0005\u0003\u0003N\n=W\"\u0001=\n\u0007\tE\u0007P\u0001\u0005F]Vl\u0007*\u00198e\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005/\fab\u001c8CY>\u001c7n\u00117jG.,G\rF\u00031\u00053\u0014Y\u000e\u0003\u0005\u0003:\tM\u0007\u0019\u0001B\u001e\u0011!\u0011)Da5A\u0002\t\u0015\u0001b\u0002Bp\u0001\u0011\u0005!\u0011]\u0001\u0012_:,e\u000e^5us\u000e{G\u000e\\5tS>tGc\u0001\u0019\u0003d\"A!1\tBo\u0001\u0004\u0011)\tC\u0004\u0003h\u0002!\tA!;\u0002!=tWI\u001c;jif\u001cF/\u00198eS:<Gc\u0001\u0019\u0003l\"A!1\tBs\u0001\u0004\u0011)\t\u0003\u0004\u0003p\u0002!\tAV\u0001\u0016_:tU-[4iE>\u0014(\t\\8dW\u000eC\u0017M\\4f\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0005k\f!cY1o\u0007>tg.Z2u%\u0016$7\u000f^8oKR\u0019ANa>\t\u000f\tE$\u0011\u001fa\u0001M\"9!1 \u0001\u0005\u0002\tu\u0018\u0001E:ue>tw\rU8xKJdUM^3m)\r1'q \u0005\b\u0005c\u0012I\u00101\u0001g\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0007\u000b\tab^3bWB{w/\u001a:MKZ,G\u000eF\u0002g\u0007\u000fAqA!\u001d\u0004\u0002\u0001\u0007a\r\u0003\u0004\u0004\f\u0001!\tAV\u0001\u0011]>$\u0018NZ=US2,7\t[1oO\u0016Dqaa\u0004\u0001\t\u0003\u0019\t\"\u0001\to_RLg-\u001f)beR\u001c\u0005.\u00198hKR\u0019\u0001ga\u0005\t\rm\u001bi\u00011\u0001+\u0011\u001d\u00199\u0002\u0001C\u0001\u00073\t!#\u001b8uKJt\u0017\r\u001c)beR\u001c\u0005.\u00198hKR\u0019\u0001ga\u0007\t\rm\u001b)\u00021\u0001+\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007C\tq\"\\;mi&\u0004\u0016M\u001d;DQ\u0006tw-\u001a\u000b\u0004a\r\r\u0002\u0002CA>\u0007;\u0001\ra!\n\u0011\tq\u001a9CK\u0005\u0004\u0007Si$AC\"pY2,7\r^5p]\"11Q\u0006\u0001\u0005BY\u000b\u0011\"\\1sW\u0012K'\u000f^=\t\r\rE\u0002\u0001\"\u0001W\u0003)i\u0017M]6SK:$WM\u001d\u0005\b\u0007k\u0001A\u0011AB\u001c\u0003-\u0011XmY1mG2Kw\r\u001b;\u0015\u000bA\u001aId!\u0010\t\u000f\rm21\u0007a\u0001Y\u0006\u00191o[=\t\u000f\r}21\u0007a\u0001Y\u0006)!\r\\8dW\"911\t\u0001\u0005\u0002\r\u0015\u0013\u0001\u00068pi&4\u0017PT3jO\"\u0014wN]\"iC:<W\rF\u00021\u0007\u000fBqA!\u001d\u0004B\u0001\u0007a\rC\u0004\u0004L\u0001!\ta!\u0014\u0002\u0013\u0011\u0014x\u000e]%uK6\u001cHc\u0001\u0019\u0004P!A1\u0011KB%\u0001\u0004\u0019\u0019&A\u0003ji\u0016l7\u000f\u0005\u0004\u0003\"\t\u001d\"Q\u000b\u0005\r\u0007/\u0002\u0001\u0013!A\u0001\u0002\u0013\u00051\u0011L\u0001\u000eaJ|G/Z2uK\u0012$\u0003o\\:\u0015\u0007Q\u001cY\u0006\u0003\u00056\u0007+\n\t\u00111\u0001\u001e\u00111\u0019y\u0006\u0001I\u0001\u0002\u0003\u0005I\u0011AB1\u0003=\u0001(o\u001c;fGR,G\rJ<pe2$G\u0003\u0002BX\u0007GB\u0001\"NB/\u0003\u0003\u0005\r!H\u0004\b\u0007O\u0012\u0001\u0012AB5\u00035!\u0016\u000e\\3Nk2$\u0018\u000e]1siB\u0019ada\u001b\u0007\r\u0005\u0011\u0001\u0012AB7'\u0011\u0019Yga\u001c\u0011\u0007E\u001a\t(C\u0002\u0004t\u0019\u0012a!\u00118z%\u00164\u0007bB\u000e\u0004l\u0011\u00051q\u000f\u000b\u0003\u0007SB\u0001ba\u001f\u0004l\u0011\u00051QP\u0001\u0011O\u0016$xJ]\"p]Z,'\u000f\u001e+jY\u0016$R!HB@\u0007\u0003Cq!FB=\u0001\u0004\u0011y\u000bC\u0004\u0004\u0004\u000ee\u0004\u0019\u0001;\u0002\u0007A|7\u000f\u0003\u0005\u0004\b\u000e-D\u0011ABE\u0003E9W\r^(s\u0007>tg/\u001a:u)&dWM\r\u000b\u0007\u0007\u0017\u001b\tja%\u0011\u000bE\u001ai)\b7\n\u0007\r=eE\u0001\u0004UkBdWM\r\u0005\b+\r\u0015\u0005\u0019\u0001BX\u0011\u001d\u0019\u0019i!\"A\u0002QD\u0001ba&\u0004l\u0011\u00051\u0011T\u0001\bO\u0016$H+\u001b7f)\u0015i21TBO\u0011\u001d)2Q\u0013a\u0001\u0005_Cqaa!\u0004\u0016\u0002\u0007A\u000f\u0003\u0005\u0004\"\u000e-D\u0011ABR\u0003Y\u0019\u0007.Z2l\u001d>,e\u000e^5us\u000e{G\u000e\\5tS>tGc\u00027\u0004&\u000e\u001d6\u0011\u0016\u0005\b+\r}\u0005\u0019\u0001BX\u0011\u001d\u0019\u0019ia(A\u0002QDaaWBP\u0001\u0004Q\u0003\u0002CBW\u0007W\"\taa,\u0002\u0019\r\fg\u000e\u00157bG\u0016\u0004\u0016M\u001d;\u0015\u000f1\u001c\tla-\u00046\"9Qca+A\u0002\t=\u0006bBBB\u0007W\u0003\r\u0001\u001e\u0005\u00077\u000e-\u0006\u0019\u0001\u0016\t\u0011\re61\u000eC\u0001\u0007w\u000b1B]3qY\u0006\u001cW-\u00192mKR)An!0\u0004@\"9Qca.A\u0002\t=\u0006bBBB\u0007o\u0003\r\u0001\u001e\u0005\t\u0007\u0007\u001cY\u0007\"\u0001\u0004F\u00069\u0011\r\u001a3QCJ$HcB\u000f\u0004H\u000e%71\u001a\u0005\b+\r\u0005\u0007\u0019\u0001BX\u0011\u001d\u0019\u0019i!1A\u0002QDaaWBa\u0001\u0004Q\u0003\u0002CBh\u0007W\"\ta!5\u0002!!\fg\u000e\u001a7f\t\u0016\u001c8\rU1dW\u0016$Hc\u0002\u0019\u0004T\u000eU7q\u001b\u0005\b+\r5\u0007\u0019\u0001BX\u0011\u001d\u0019\u0019i!4A\u0002QD\u0001\"a\f\u0004N\u0002\u00071\u0011\u001c\t\u0005\u00077\u001cy.\u0004\u0002\u0004^*\u0019\u0011q\u0006\f\n\t\r\u00058Q\u001c\u0002\r!\u0006\u001c7.\u001a;DkN$x.\u001c\u0005\t\u0007K\u001cY\u0007\"\u0001\u0004h\u0006a\u0001.\u00198eY\u0016\u0004\u0016mY6fiRI\u0001g!;\u0004l\u000e58\u0011\u001f\u0005\b\u0007\u0007\u001b\u0019\u000f1\u0001u\u0011\u001d)21\u001da\u0001\u0005_Cqaa<\u0004d\u0002\u0007a-A\u0001j\u0011!\tyca9A\u0002\re\u0007\u0002CB{\u0007W\"\taa>\u0002\u001b\r\u0014X-\u0019;f\rJ|WN\u0014\"U)\ri2\u0011 \u0005\t\u0003K\u0019\u0019\u00101\u0001\u0002\u0018!A1Q`B6\t\u0003\u0019y0\u0001\u0005ee>\u0004\u0018\n^3n)\u001d\u0001D\u0011\u0001C\u0003\t\u000fA\u0001\u0002b\u0001\u0004|\u0002\u0007!QK\u0001\u0006gR\f7m\u001b\u0005\b+\rm\b\u0019\u0001BX\u0011!\u0019\u0019ia?A\u0002\u0011%\u0001\u0003\u0002C\u0006\t#i!\u0001\"\u0004\u000b\u0007\u0011=a#A\u0002wK\u000eLA\u0001b\u0005\u0005\u000e\t9a+Z2u_J\u001c\u0004")
public class TileMultipart
extends TileEntity
implements IChunkLoadTile {
    private Seq<TMultiPart> partList = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void dropItem(ItemStack itemStack, World world, Vector3 vector3) {
        TileMultipart$.MODULE$.dropItem(itemStack, world, vector3);
    }

    public static TileMultipart createFromNBT(NBTTagCompound nBTTagCompound) {
        return TileMultipart$.MODULE$.createFromNBT(nBTTagCompound);
    }

    public static void handlePacket(BlockPos blockPos, World world, int n, PacketCustom packetCustom) {
        TileMultipart$.MODULE$.handlePacket(blockPos, world, n, packetCustom);
    }

    public static void handleDescPacket(World world, BlockPos blockPos, PacketCustom packetCustom) {
        TileMultipart$.MODULE$.handleDescPacket(world, blockPos, packetCustom);
    }

    public static TileMultipart addPart(World world, BlockPos blockPos, TMultiPart tMultiPart) {
        return TileMultipart$.MODULE$.addPart(world, blockPos, tMultiPart);
    }

    public static boolean replaceable(World world, BlockPos blockPos) {
        return TileMultipart$.MODULE$.replaceable(world, blockPos);
    }

    public static boolean canPlacePart(World world, BlockPos blockPos, TMultiPart tMultiPart) {
        return TileMultipart$.MODULE$.canPlacePart(world, blockPos, tMultiPart);
    }

    public static boolean checkNoEntityCollision(World world, BlockPos blockPos, TMultiPart tMultiPart) {
        return TileMultipart$.MODULE$.checkNoEntityCollision(world, blockPos, tMultiPart);
    }

    public static TileMultipart getTile(World world, BlockPos blockPos) {
        return TileMultipart$.MODULE$.getTile(world, blockPos);
    }

    public static Tuple2<TileMultipart, Object> getOrConvertTile2(World world, BlockPos blockPos) {
        return TileMultipart$.MODULE$.getOrConvertTile2(world, blockPos);
    }

    public static TileMultipart getOrConvertTile(World world, BlockPos blockPos) {
        return TileMultipart$.MODULE$.getOrConvertTile(world, blockPos);
    }

    public /* synthetic */ BlockPos protected$pos(TileMultipart x$1) {
        return x$1.pos;
    }

    public /* synthetic */ World protected$world(TileMultipart x$1) {
        return x$1.world;
    }

    public Seq<TMultiPart> partList() {
        return this.partList;
    }

    public void partList_$eq(Seq<TMultiPart> x$1) {
        this.partList = x$1;
    }

    public List<TMultiPart> jPartList() {
        return JavaConversions$.MODULE$.seqAsJavaList(this.partList());
    }

    public void from(TileMultipart that) {
        this.copyFrom(that);
        this.loadFrom(that);
        that.loadTo(this);
    }

    public void copyFrom(TileMultipart that) {
        this.partList_$eq(that.partList());
    }

    public void loadFrom(TileMultipart that) {
        this.partList().foreach((Function1)new Serializable(this){
            private final /* synthetic */ TileMultipart $outer;

            public final void apply(TMultiPart x$1) {
                x$1.bind(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void loadTo(TileMultipart that) {
    }

    public void clearParts() {
        this.partList_$eq((Seq<TMultiPart>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public void bindPart(TMultiPart part) {
    }

    public void partAdded(TMultiPart part) {
    }

    public void partRemoved(TMultiPart part, int p) {
    }

    public boolean getWeakChanges() {
        return false;
    }

    public void onNeighborTileChange(BlockPos neighborPos) {
    }

    public TMultiPart partMap(int slot) {
        return null;
    }

    public void operate(Function1<TMultiPart, BoxedUnit> f) {
        for (TMultiPart p : this.partList()) {
            Object object = p.tile() == null ? BoxedUnit.UNIT : f.apply((Object)p);
        }
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList taglist = new NBTTagList();
        this.partList().foreach((Function1)new Serializable(this, taglist){
            private final NBTTagList taglist$1;

            public final void apply(TMultiPart part) {
                NBTTagCompound parttag = new NBTTagCompound();
                parttag.setString("id", part.getType().toString());
                part.save(parttag);
                this.taglist$1.appendTag((NBTBase)parttag);
            }
            {
                this.taglist$1 = taglist$1;
            }
        });
        tag.setTag("parts", (NBTBase)taglist);
        return tag;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.partList().size());
        this.partList().foreach((Function1)new Serializable(this, packet){
            private final MCDataOutput packet$1;

            public final void apply(TMultiPart part) {
                MultiPartRegistry$.MODULE$.writePartID(this.packet$1, part);
                part.writeDesc(this.packet$1);
            }
            {
                this.packet$1 = packet$1;
            }
        });
    }

    public MCDataOutput getWriteStream(TMultiPart part) {
        return this.getWriteStream().writeByte(this.partList().indexOf((Object)part));
    }

    private MultipartSPH.MCByteStream getWriteStream() {
        return MultipartSPH$.MODULE$.getTileStream(this.world, this.getPos());
    }

    public boolean canAddPart(TMultiPart part) {
        return BoxesRunTime.unboxToBoolean((Object)MultipartCompatiblity$.MODULE$.canAddPart().apply((Object)this.world, (Object)this.pos)) && !this.partList().contains((Object)part) && this.occlusionTest(this.partList(), part);
    }

    public boolean canReplacePart(TMultiPart opart, TMultiPart npart) {
        Seq olist = (Seq)this.partList().filterNot((Function1)new Serializable(this, opart){
            private final TMultiPart opart$1;

            public final boolean apply(TMultiPart x$2) {
                TMultiPart tMultiPart = x$2;
                TMultiPart tMultiPart2 = this.opart$1;
                return !(tMultiPart != null ? !tMultiPart.equals(tMultiPart2) : tMultiPart2 != null);
            }
            {
                this.opart$1 = opart$1;
            }
        });
        if (olist.contains((Object)npart)) {
            return false;
        }
        return this.occlusionTest((Seq<TMultiPart>)olist, npart);
    }

    public boolean occlusionTest(Seq<TMultiPart> parts, TMultiPart npart) {
        return parts.forall((Function1)new Serializable(this, npart){
            private final TMultiPart npart$1;

            public final boolean apply(TMultiPart part) {
                return part.occlusionTest(this.npart$1) && this.npart$1.occlusionTest(part);
            }
            {
                this.npart$1 = npart$1;
            }
        });
    }

    public void addPart_impl(TMultiPart part) {
        if (!this.world.isRemote) {
            this.writeAddPart(part);
        }
        this.addPart_do(part);
        part.onAdded();
        this.partAdded(part);
        this.notifyPartChange(part);
        this.notifyTileChange();
        this.markDirty();
        this.markRender();
    }

    public void writeAddPart(TMultiPart part) {
        MCDataOutputWrapper stream = this.getWriteStream().writeByte(253);
        MultiPartRegistry$.MODULE$.writePartID((MCDataOutput)stream, part);
        part.writeDesc((MCDataOutput)stream);
    }

    public void addPart_do(TMultiPart part) {
        Predef$.MODULE$.assert(this.partList().size() < 250, (Function0)new Serializable(this){

            public final String apply() {
                return "Tried to add more than 250 parts to the one tile. You're doing it wrong";
            }
        });
        this.partList_$eq((Seq<TMultiPart>)((Seq)this.partList().$colon$plus((Object)part, Seq$.MODULE$.canBuildFrom())));
        this.bindPart(part);
        part.bind(this);
    }

    public TileMultipart remPart(TMultiPart part) {
        Predef$.MODULE$.assert(!this.world.isRemote, (Function0)new Serializable(this){

            public final String apply() {
                return "Cannot remove multi parts from a client tile";
            }
        });
        return this.remPart_impl(part);
    }

    public TileMultipart remPart_impl(TMultiPart part) {
        this.remPart_do(part, !this.world.isRemote);
        if (this.isInvalid()) {
            return null;
        }
        TileMultipart tile = MultipartGenerator$.MODULE$.partRemoved(this);
        tile.notifyPartChange(part);
        tile.markDirty();
        tile.markRender();
        return tile;
    }

    /*
     * WARNING - void declaration
     */
    private int remPart_do(TMultiPart part, boolean sendPacket) {
        void var3_3;
        int r = this.partList().indexOf((Object)part);
        if (r < 0) {
            throw new IllegalArgumentException("Tried to remove a non-existant part");
        }
        part.preRemove();
        this.partList_$eq((Seq<TMultiPart>)((Seq)this.partList().filterNot((Function1)new Serializable(this, part){
            private final TMultiPart part$1;

            public final boolean apply(TMultiPart x$3) {
                TMultiPart tMultiPart = x$3;
                TMultiPart tMultiPart2 = this.part$1;
                return !(tMultiPart != null ? !tMultiPart.equals(tMultiPart2) : tMultiPart2 != null);
            }
            {
                this.part$1 = part$1;
            }
        })));
        Object object = sendPacket ? this.getWriteStream().writeByte(254).writeByte(r) : BoxedUnit.UNIT;
        this.partRemoved(part, r);
        part.onRemoved();
        part.tile_$eq(null);
        Object object2 = this.partList().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)this.world.setBlockToAir(this.pos)) : BoxedUnit.UNIT;
        return (int)var3_3;
    }

    public void loadParts(Iterable<TMultiPart> parts) {
        this.clearParts();
        parts.foreach((Function1)new Serializable(this){
            private final /* synthetic */ TileMultipart $outer;

            public final void apply(TMultiPart p) {
                this.$outer.addPart_do(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.world != null) {
            if (this.world.isRemote) {
                this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this){

                    public final void apply(TMultiPart x$4) {
                        x$4.onWorldJoin();
                    }
                });
            }
            this.notifyPartChange(null);
        }
    }

    public final void setValid(boolean b) {
        if (b) {
            super.validate();
        } else {
            super.invalidate();
        }
    }

    public void invalidate() {
        if (!this.isInvalid()) {
            super.invalidate();
            if (this.world != null) {
                this.partList().foreach((Function1)new Serializable(this){

                    public final void apply(TMultiPart x$5) {
                        x$5.onWorldSeparate();
                    }
                });
                if (this.world.isRemote) {
                    TileCache$.MODULE$.remove(this);
                }
            }
        }
    }

    public void validate() {
        super.validate();
        if (this.world != null && this.world.isRemote) {
            TileCache$.MODULE$.add(this);
        }
    }

    public void addCollisionBoxToList(AxisAlignedBB entityBox, List<AxisAlignedBB> list) {
        Cuboid6 mask = new Cuboid6(entityBox).subtract(this.pos);
        this.partList().foreach((Function1)new Serializable(this, list, mask){
            private final /* synthetic */ TileMultipart $outer;
            public final List list$1;
            public final Cuboid6 mask$1;

            public final void apply(TMultiPart x$6) {
                JavaConversions$.MODULE$.iterableAsScalaIterable(x$6.getCollisionBoxes()).foreach((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$addCollisionBoxToList$1 $outer;

                    public final Object apply(Cuboid6 c) {
                        return c.intersects(this.$outer.mask$1) ? BoxesRunTime.boxToBoolean((boolean)this.$outer.list$1.add(c.aabb().offset(this.$outer.codechicken$multipart$TileMultipart$$anonfun$$$outer().protected$pos(this.$outer.codechicken$multipart$TileMultipart$$anonfun$$$outer())))) : BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TileMultipart codechicken$multipart$TileMultipart$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.list$1 = list$1;
                this.mask$1 = mask$1;
            }
        });
    }

    public PartRayTraceResult collisionRayTrace(Vec3d start, Vec3d end) {
        return (PartRayTraceResult)((Object)JavaConversions$.MODULE$.iterableAsScalaIterable(this.rayTraceAll(start, end)).headOption().orNull(Predef$.MODULE$.$conforms()));
    }

    public java.lang.Iterable<PartRayTraceResult> rayTraceAll(Vec3d start, Vec3d end) {
        ObjectRef list = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ((IterableLike)((TraversableViewLike)this.partList().view().zipWithIndex(SeqView$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){

            public final boolean apply(Tuple2<TMultiPart, Object> check$ifrefutable$1) {
                Tuple2<TMultiPart, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach((Function1)new Serializable(this, start, end, list){
            private final Vec3d start$1;
            private final Vec3d end$1;
            private final ObjectRef list$2;

            public final Object apply(Tuple2<TMultiPart, Object> x$7) {
                Tuple2<TMultiPart, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TMultiPart p = (TMultiPart)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    CuboidRayTraceResult cuboidRayTraceResult = p.collisionRayTrace(this.start$1, this.end$1);
                    if (cuboidRayTraceResult != null) {
                        CuboidRayTraceResult cuboidRayTraceResult2 = cuboidRayTraceResult;
                        PartRayTraceResult partMOP = new PartRayTraceResult(i, cuboidRayTraceResult2);
                        boxedUnit = ((ListBuffer)this.list$2.elem).$plus$eq((Object)((Object)partMOP));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.list$2 = list$2;
            }
        });
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)((ListBuffer)((ListBuffer)list.elem).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))));
    }

    public void harvestPart(PartRayTraceResult hit, EntityPlayer player) {
        TMultiPart tMultiPart = (TMultiPart)this.partList().apply(hit.partIndex());
        if (tMultiPart == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            tMultiPart.harvest(player, hit);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<ItemStack> getDrops() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.partList().foreach((Function1)new Serializable(this, list){
            public final ArrayList list$3;

            public final void apply(TMultiPart x$8) {
                JavaConversions$.MODULE$.iterableAsScalaIterable(x$8.getDrops()).foreach((Function1)new Serializable(this){
                    private final /* synthetic */ $anonfun$getDrops$1 $outer;

                    public final boolean apply(ItemStack x$1) {
                        return this.$outer.list$3.add(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.list$3 = list$3;
            }
        });
        return var1_1;
    }

    public ItemStack getPickBlock(PartRayTraceResult hit) {
        TMultiPart tMultiPart = (TMultiPart)this.partList().apply(hit.partIndex());
        ItemStack itemStack = tMultiPart == null ? null : tMultiPart.pickItem(hit);
        return itemStack;
    }

    public boolean isSolid(int side) {
        boolean bl;
        TMultiPart tMultiPart = this.partMap(side);
        if (tMultiPart instanceof TFacePart) {
            TFacePart tFacePart = (TFacePart)((Object)tMultiPart);
            bl = tFacePart.solid(side);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canPlaceTorchOnTop() {
        return this.partList().exists((Function1)new Serializable(this){

            public final boolean apply(TMultiPart x$9) {
                return x$9.canPlaceTorchOnTop();
            }
        }) || this.isSolid(1);
    }

    public float getExplosionResistance(Entity entity) {
        return BoxesRunTime.unboxToFloat((Object)((TraversableOnce)this.partList().view().map((Function1)new Serializable(this, entity){
            private final Entity entity$1;

            public final float apply(TMultiPart x$10) {
                return x$10.getExplosionResistance(this.entity$1);
            }
            {
                this.entity$1 = entity$1;
            }
        }, SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Float$.MODULE$));
    }

    public int getLightValue() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.partList().view().map((Function1)new Serializable(this){

            public final int apply(TMultiPart x$11) {
                return x$11.getLightValue();
            }
        }, SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, PartRayTraceResult hit) {
        if (hit == null) {
            return 0.01f;
        }
        TMultiPart tMultiPart = (TMultiPart)this.partList().apply(hit.partIndex());
        float f = tMultiPart == null ? 0.01f : tMultiPart.getStrength(player, hit);
        return f;
    }

    public void onChunkUnload() {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this){

            public final void apply(TMultiPart x$12) {
                x$12.onChunkUnload();
            }
        });
    }

    public void onChunkLoad() {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this){

            public final void apply(TMultiPart x$13) {
                x$13.onChunkLoad();
            }
        });
    }

    public void setWorldCreate(World worldIn) {
        this.setWorld(worldIn);
    }

    public void onMoved() {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this){

            public final void apply(TMultiPart x$14) {
                x$14.onMoved();
            }
        });
    }

    public boolean onBlockActivated(EntityPlayer player, PartRayTraceResult hit, EnumHand hand) {
        if (hit == null) {
            return false;
        }
        TMultiPart tMultiPart = (TMultiPart)this.partList().apply(hit.partIndex());
        boolean bl = tMultiPart == null ? false : tMultiPart.activate(player, hit, player.getHeldItem(hand), hand);
        return bl;
    }

    public void onBlockClicked(EntityPlayer player, PartRayTraceResult hit) {
        if (hit != null) {
            TMultiPart tMultiPart = (TMultiPart)this.partList().apply(hit.partIndex());
            if (tMultiPart == null) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                tMultiPart.click(player, hit, player.getHeldItemMainhand());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void onEntityCollision(Entity entity) {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this, entity){
            private final Entity entity$2;

            public final void apply(TMultiPart x$15) {
                x$15.onEntityCollision(this.entity$2);
            }
            {
                this.entity$2 = entity$2;
            }
        });
    }

    public void onEntityStanding(Entity entity) {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this, entity){
            private final Entity entity$3;

            public final void apply(TMultiPart x$16) {
                x$16.onEntityStanding(this.entity$3);
            }
            {
                this.entity$3 = entity$3;
            }
        });
    }

    public void onNeighborBlockChange() {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this){

            public final void apply(TMultiPart x$17) {
                x$17.onNeighborChanged();
            }
        });
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return 0;
    }

    public void notifyTileChange() {
        this.world.notifyNeighborsOfStateChange(this.pos, (Block)MultipartProxy$.MODULE$.block(), true);
    }

    public void notifyPartChange(TMultiPart part) {
        this.internalPartChange(part);
        this.world.notifyBlockUpdate(this.pos, MultipartProxy$.MODULE$.block().getDefaultState(), MultipartProxy$.MODULE$.block().getDefaultState(), 3);
        this.world.notifyNeighborsOfStateChange(this.pos, (Block)MultipartProxy$.MODULE$.block(), true);
        this.world.checkLight(this.pos);
    }

    public void internalPartChange(TMultiPart part) {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this, part){
            private final TMultiPart part$2;

            public final void apply(TMultiPart p) {
                TMultiPart tMultiPart = this.part$2;
                TMultiPart tMultiPart2 = p;
                if (tMultiPart == null ? tMultiPart2 != null : !tMultiPart.equals(tMultiPart2)) {
                    p.onPartChanged(this.part$2);
                }
            }
            {
                this.part$2 = part$2;
            }
        });
    }

    public void multiPartChange(Collection<TMultiPart> parts) {
        this.operate((Function1<TMultiPart, BoxedUnit>)new Serializable(this, parts){
            private final Collection parts$1;

            public final void apply(TMultiPart p) {
                if (!this.parts$1.contains(p)) {
                    JavaConversions$.MODULE$.collectionAsScalaIterable(this.parts$1).foreach((Function1)new Serializable(this, p){
                        private final TMultiPart p$1;

                        public final void apply(TMultiPart part) {
                            this.p$1.onPartChanged(part);
                        }
                        {
                            this.p$1 = p$1;
                        }
                    });
                }
            }
            {
                this.parts$1 = parts$1;
            }
        });
    }

    public void markDirty() {
        this.world.markChunkDirty(this.pos, (TileEntity)this);
    }

    public void markRender() {
        this.world.markBlockRangeForRenderUpdate(this.pos, this.pos);
    }

    public void recalcLight(boolean sky, boolean block) {
        Object object = sky && !this.world.provider.isNether() ? BoxesRunTime.boxToBoolean((boolean)this.world.checkLightFor(EnumSkyBlock.SKY, this.pos)) : BoxedUnit.UNIT;
        if (block) {
            this.world.checkLightFor(EnumSkyBlock.BLOCK, this.pos);
        }
    }

    public void notifyNeighborChange(int side) {
        this.world.notifyNeighborsOfStateChange(this.getPos().offset(EnumFacing.values()[side]), (Block)MultipartProxy$.MODULE$.block(), true);
    }

    public void dropItems(java.lang.Iterable<ItemStack> items) {
        Vector3 pos = Vector3.fromTileCenter((TileEntity)this);
        JavaConversions$.MODULE$.iterableAsScalaIterable(items).foreach((Function1)new Serializable(this, pos){
            private final /* synthetic */ TileMultipart $outer;
            private final Vector3 pos$1;

            public final void apply(ItemStack item) {
                TileMultipart$.MODULE$.dropItem(item, this.$outer.protected$world(this.$outer), this.pos$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pos$1 = pos$1;
            }
        });
    }
}

