/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McMultipartSPH;
import codechicken.multipart.minecraft.McSidedMetaPart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    private ThreadLocal<Object> placing = new ThreadLocal();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().isRemote) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            if (EventHandler.place(event.getEntityPlayer(), event.getHand(), event.getEntityPlayer().world)) {
                event.setCanceled(true);
            }
            this.placing.set(null);
        }
    }

    public static boolean place(EntityPlayer player, EnumHand hand, World world) {
        RayTraceResult hit = RayTracer.retrace((EntityPlayer)player);
        if (hit == null) {
            return false;
        }
        BlockPos pos = new BlockPos((Vec3i)hit.getBlockPos()).offset(hit.sideHit);
        ItemStack held = player.getHeldItem(hand);
        McSidedMetaPart part = null;
        if (held.isEmpty()) {
            return false;
        }
        Block heldBlock = Block.getBlockFromItem((Item)held.getItem());
        if (heldBlock == null) {
            return false;
        }
        if (heldBlock == Blocks.TORCH) {
            part = new TorchPart();
        } else if (heldBlock == Blocks.LEVER) {
            part = new LeverPart();
        } else if (heldBlock == Blocks.STONE_BUTTON || heldBlock == Blocks.WOODEN_BUTTON) {
            part = new ButtonPart();
        } else if (heldBlock == Blocks.REDSTONE_TORCH) {
            part = new RedstoneTorchPart();
        }
        if (part == null) {
            return false;
        }
        part.setStateOnPlacement(world, pos, hit.sideHit, hit.hitVec, (EntityLivingBase)player, held);
        TileMultipart tile = TileMultipart.getOrConvertTile(world, pos);
        if (tile == null || !tile.canAddPart(part)) {
            return false;
        }
        if (!world.isRemote) {
            TileMultipart.addPart(world, pos, part);
            SoundType sound = part.getBlock().getSoundType();
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound.getPlaceSound(), SoundCategory.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            if (!player.capabilities.isCreativeMode) {
                held.shrink(1);
                if (held.getCount() == 0) {
                    player.inventory.mainInventory.set(player.inventory.currentItem, (Object)ItemStack.EMPTY);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
                }
            }
        } else {
            player.swingArm(hand);
            new PacketCustom(McMultipartSPH.channel, 1).writeBoolean(hand == EnumHand.MAIN_HAND).sendToServer();
        }
        return true;
    }
}

