/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.Vector3;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class McSidedMetaPart
extends McMetaPart
implements TFacePart {
    public McSidedMetaPart() {
    }

    public McSidedMetaPart(IBlockState state) {
        super(state);
    }

    public abstract int getSideFromState();

    @Override
    public void onNeighborChanged() {
        if (!this.world().isRemote) {
            this.dropIfCantStay();
        }
    }

    public boolean canStay() {
        EnumFacing facing = EnumFacing.VALUES[this.getSideFromState()];
        BlockPos pos = new BlockPos((Vec3i)this.tile().getPos()).offset(facing);
        return this.world().isSideSolid(pos, facing);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem(new ItemStack(this.getBlock()), this.world(), Vector3.fromTileCenter((TileEntity)this.tile()));
        this.tile().remPart(this);
    }

    @Override
    public int getSlotMask() {
        return 1 << this.getSideFromState();
    }

    @Override
    public boolean solid(int side) {
        return false;
    }

    @Override
    public int redstoneConductionMap() {
        return 31;
    }
}

