/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.IRandomDisplayTickPart;
import codechicken.multipart.minecraft.Content;
import codechicken.multipart.minecraft.McSidedMetaPart;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TorchPart
extends McSidedMetaPart
implements IRandomDisplayTickPart {
    public static BlockTorch torch = (BlockTorch)Blocks.TORCH;

    public TorchPart() {
        this.state = torch.getDefaultState();
    }

    public TorchPart(IBlockState state) {
        super(state);
    }

    @Override
    public Block getBlock() {
        return torch;
    }

    @Override
    public ResourceLocation getType() {
        return Content.TORCH;
    }

    @Override
    public int getSideFromState() {
        return ((EnumFacing)this.state.getValue((IProperty)BlockTorch.FACING)).getOpposite().ordinal();
    }

    @Override
    public boolean canStay() {
        if (this.getSideFromState() == 0) {
            BlockPos offset = this.pos().offset(EnumFacing.DOWN);
            IBlockState state = this.world().getBlockState(offset);
            if (state.getBlock().canPlaceTorchOnTop(state, (IBlockAccess)this.world(), offset)) {
                return true;
            }
        }
        return super.canStay();
    }

    @Override
    public void randomDisplayTick(Random random) {
        this.getBlock().randomDisplayTick(this.state, this.world(), this.pos(), random);
    }
}

