/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry$;
import codechicken.multipart.MultipartGenerator$;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileCache$;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartCompatiblity$;
import codechicken.multipart.handler.MultipartProxy$;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TileMultipart$ {
    public static final TileMultipart$ MODULE$;

    static {
        new TileMultipart$();
    }

    public TileMultipart getOrConvertTile(World world, BlockPos pos) {
        return (TileMultipart)((Object)this.getOrConvertTile2(world, pos)._1());
    }

    public Tuple2<TileMultipart, Object> getOrConvertTile2(World world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileMultipart) {
            return new Tuple2((Object)((TileMultipart)t), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        java.lang.Iterable<TMultiPart> p = MultiPartRegistry$.MODULE$.convertBlock(world, pos, world.func_180495_p(pos));
        if (JavaConversions$.MODULE$.iterableAsScalaIterable(p).nonEmpty()) {
            TileMultipart t2 = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Iterable<TMultiPart>)JavaConversions$.MODULE$.iterableAsScalaIterable(p), world.field_72995_K);
            t2.func_174878_a(pos);
            t2.func_145834_a(world);
            JavaConversions$.MODULE$.iterableAsScalaIterable(p).foreach((Function1)new Serializable(t2){
                private final TileMultipart t$1;

                public final void apply(TMultiPart part) {
                    this.t$1.addPart_do(part);
                }
                {
                    this.t$1 = t$1;
                }
            });
            return new Tuple2((Object)t2, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public TileMultipart getTile(World world, BlockPos pos) {
        TileMultipart tileMultipart;
        TileEntity tileEntity = world.func_175625_s(pos);
        TileMultipart tileMultipart2 = tileEntity instanceof TileMultipart ? (tileMultipart = (TileMultipart)tileEntity) : null;
        return tileMultipart2;
    }

    public boolean checkNoEntityCollision(World world, BlockPos pos, TMultiPart part) {
        return JavaConversions$.MODULE$.iterableAsScalaIterable(part.getCollisionBoxes()).forall((Function1)new Serializable(world, pos){
            private final World world$1;
            private final BlockPos pos$2;

            public final boolean apply(Cuboid6 b) {
                return this.world$1.func_72855_b(b.aabb().func_186670_a(this.pos$2));
            }
            {
                this.world$1 = world$1;
                this.pos$2 = pos$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean canPlacePart(World world, BlockPos pos, TMultiPart part) {
        if (this.checkNoEntityCollision(world, pos, part)) {
            void var4_4;
            TileMultipart t = this.getOrConvertTile(world, pos);
            if (t == null) {
                if (BoxesRunTime.unboxToBoolean((Object)MultipartCompatiblity$.MODULE$.canAddPart().apply((Object)world, (Object)pos))) {
                    return this.replaceable(world, pos);
                }
                return false;
            }
            return var4_4.canAddPart(part);
        }
        return false;
    }

    public boolean replaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.isAir(state, (IBlockAccess)world, pos) || block.func_176200_f((IBlockAccess)world, pos);
    }

    public TileMultipart addPart(World world, BlockPos pos, TMultiPart part) {
        Predef$.MODULE$.assert(!world.field_72995_K, (Function0)new Serializable(){

            public final String apply() {
                return "Cannot add multi parts to a client tile.";
            }
        });
        return MultipartGenerator$.MODULE$.addPart(world, pos, part);
    }

    public void handleDescPacket(World world, BlockPos pos, PacketCustom packet) {
        TileMultipart tilemp;
        short nparts = packet.readUByte();
        ListBuffer parts = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)nparts).foreach((Function1)new Serializable(packet, parts){
            private final PacketCustom packet$2;
            private final ListBuffer parts$2;

            public final ListBuffer<TMultiPart> apply(int i) {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)this.packet$2);
                part.readDesc((MCDataInput)this.packet$2);
                return this.parts$2.$plus$eq((Object)part);
            }
            {
                this.packet$2 = packet$2;
                this.parts$2 = parts$2;
            }
        });
        if (parts.isEmpty()) {
            return;
        }
        TileEntity t = world.func_175625_s(pos);
        TileMultipart tileMultipart = tilemp = MultipartGenerator$.MODULE$.generateCompositeTile(t, (Iterable<TMultiPart>)parts, true);
        TileEntity tileEntity = t;
        if (tileMultipart == null ? tileEntity != null : !((Object)((Object)tileMultipart)).equals(tileEntity)) {
            world.func_175656_a(pos, MultipartProxy$.MODULE$.block().func_176223_P());
            MultipartGenerator$.MODULE$.silentAddTile(world, pos, tilemp);
        }
        tilemp.loadParts((Iterable<TMultiPart>)parts);
        tilemp.notifyTileChange();
        tilemp.markRender();
    }

    public void handlePacket(BlockPos pos, World world, int i, PacketCustom packet) {
        int n = i;
        switch (n) {
            default: {
                ((TMultiPart)this.tilemp$1(pos, world).partList().apply(i)).read((MCDataInput)packet);
                break;
            }
            case 254: {
                this.tilemp$1(pos, world).remPart_impl((TMultiPart)this.tilemp$1(pos, world).partList().apply((int)packet.readUByte()));
                break;
            }
            case 253: {
                TMultiPart part = MultiPartRegistry$.MODULE$.readPart((MCDataInput)packet);
                part.readDesc((MCDataInput)packet);
                MultipartGenerator$.MODULE$.addPart(world, pos, part);
            }
        }
    }

    public TileMultipart createFromNBT(NBTTagCompound tag) {
        NBTTagList partList = tag.func_150295_c("parts", 10);
        ListBuffer parts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partList.func_74745_c()).foreach((Function1)new Serializable(partList, parts){
            private final NBTTagList partList$1;
            private final ListBuffer parts$3;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                NBTTagCompound partTag = this.partList$1.func_150305_b(i);
                ResourceLocation partID = new ResourceLocation(partTag.func_74779_i("id"));
                TMultiPart part = MultiPartRegistry$.MODULE$.loadPart(partID, partTag);
                if (part == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    part.load(partTag);
                    boxedUnit = this.parts$3.$plus$eq((Object)part);
                }
                return boxedUnit;
            }
            {
                this.partList$1 = partList$1;
                this.parts$3 = parts$3;
            }
        });
        if (parts.isEmpty()) {
            return null;
        }
        TileMultipart tmb = MultipartGenerator$.MODULE$.generateCompositeTile(null, (Iterable<TMultiPart>)parts, false);
        tmb.func_145839_a(tag);
        tmb.loadParts((Iterable<TMultiPart>)parts);
        return tmb;
    }

    public void dropItem(ItemStack stack, World world, Vector3 pos) {
        EntityItem item = new EntityItem(world, pos.x, pos.y, pos.z, stack);
        item.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
        item.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        item.func_174867_a(10);
        world.func_72838_d((Entity)item);
    }

    private final TileMultipart tilemp$1(BlockPos pos$3, World world$2) {
        return TileCache$.MODULE$.findTile(world$2, pos$3);
    }

    private TileMultipart$() {
        MODULE$ = this;
    }
}

