/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.IRedstoneConnector;
import codechicken.multipart.IRedstoneConnectorBlock;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.IRedstoneTile;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;

public final class RedstoneInteractions$ {
    public static final RedstoneInteractions$ MODULE$;
    private final int[] vanillaSideMap;
    private final int[] sideVanillaMap;
    private final Set<Block> fullVanillaBlocks;

    static {
        new RedstoneInteractions$();
    }

    public int[] vanillaSideMap() {
        return this.vanillaSideMap;
    }

    public int[] sideVanillaMap() {
        return this.sideVanillaMap;
    }

    public Set<Block> fullVanillaBlocks() {
        return this.fullVanillaBlocks;
    }

    public int getPowerTo(TMultiPart p, int side) {
        TileMultipart tile = p.tile();
        return this.getPowerTo(tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, side, ((IRedstoneTile)((Object)tile)).openConnections(side) & this.connectionMask(p, side));
    }

    public int getPowerTo(World world, int x, int y, int z, int side, int mask) {
        return this.getPower(world, x + Facing.offsetsXForSide[side], y + Facing.offsetsYForSide[side], z + Facing.offsetsZForSide[side], side ^ 1, mask);
    }

    public int getPower(World world, int x, int y, int z, int side, int mask) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).weakPowerLevel(side, mask);
        }
        Block block = world.getBlock(x, y, z);
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).weakPowerLevel((IBlockAccess)world, x, y, z, side, mask);
        }
        int vmask = this.vanillaConnectionMask(block, (IBlockAccess)world, x, y, z, side, true);
        if ((vmask & mask) > 0) {
            int m = world.getIndirectPowerLevelTo(x, y, z, side ^ 1);
            if (m < 15) {
                Block block2 = block;
                BlockRedstoneWire blockRedstoneWire = Blocks.redstone_wire;
                if (!(block2 != null ? !block2.equals(blockRedstoneWire) : blockRedstoneWire != null)) {
                    m = Math.max(m, world.getBlockMetadata(x, y, z));
                }
            }
            return m;
        }
        return 0;
    }

    public int vanillaToSide(int vside) {
        return this.sideVanillaMap()[vside + 1];
    }

    public int otherConnectionMask(IBlockAccess world, int x, int y, int z, int side, boolean power) {
        return this.getConnectionMask(world, x + Facing.offsetsXForSide[side], y + Facing.offsetsYForSide[side], z + Facing.offsetsZForSide[side], side ^ 1, power);
    }

    public int connectionMask(TMultiPart p, int side) {
        if (p instanceof IRedstonePart && ((IRedstonePart)((Object)p)).canConnectRedstone(side)) {
            if (p instanceof IFaceRedstonePart) {
                int fside = ((IFaceRedstonePart)((Object)p)).getFace();
                if ((side & 6) == (fside & 6)) {
                    return 16;
                }
                return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
            }
            if (p instanceof IMaskedRedstonePart) {
                return ((IMaskedRedstonePart)((Object)p)).getConnectionMask(side);
            }
            return 31;
        }
        return 0;
    }

    public int getConnectionMask(IBlockAccess world, int x, int y, int z, int side, boolean power) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).getConnectionMask(side);
        }
        Block block = world.getBlock(x, y, z);
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).getConnectionMask(world, x, y, z, side);
        }
        return this.vanillaConnectionMask(block, world, x, y, z, side, power);
    }

    public int vanillaConnectionMask(Block block, IBlockAccess world, int x, int y, int z, int side, boolean power) {
        int vside;
        block14: {
            int meta;
            block13: {
                block12: {
                    block11: {
                        if (this.fullVanillaBlocks().apply((Object)block)) {
                            return 31;
                        }
                        if (side == 0) {
                            return power ? 31 : 0;
                        }
                        Block block2 = block;
                        BlockRedstoneWire blockRedstoneWire = Blocks.redstone_wire;
                        if (!(block2 == null ? blockRedstoneWire != null : !block2.equals(blockRedstoneWire))) break block11;
                        Block block3 = block;
                        BlockRedstoneComparator blockRedstoneComparator = Blocks.powered_comparator;
                        if (!(block3 == null ? blockRedstoneComparator != null : !block3.equals(blockRedstoneComparator))) break block11;
                        Block block4 = block;
                        BlockRedstoneComparator blockRedstoneComparator2 = Blocks.unpowered_comparator;
                        if (block4 != null ? !block4.equals(blockRedstoneComparator2) : blockRedstoneComparator2 != null) break block12;
                    }
                    if (side != 0) {
                        return power ? 31 : 4;
                    }
                    return 0;
                }
                vside = this.vanillaSideMap()[side];
                Block block5 = block;
                BlockRedstoneRepeater blockRedstoneRepeater = Blocks.powered_repeater;
                if (!(block5 == null ? blockRedstoneRepeater != null : !block5.equals(blockRedstoneRepeater))) break block13;
                Block block6 = block;
                BlockRedstoneRepeater blockRedstoneRepeater2 = Blocks.unpowered_repeater;
                if (block6 != null ? !block6.equals(blockRedstoneRepeater2) : blockRedstoneRepeater2 != null) break block14;
            }
            if (vside == ((meta = world.getBlockMetadata(x, y, z)) & 3) || vside == Direction.rotateOpposite[meta & 3]) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (power || block.canConnectRedstone(world, x, y, z, vside)) {
            return 31;
        }
        return 0;
    }

    private RedstoneInteractions$() {
        MODULE$ = this;
        this.vanillaSideMap = new int[]{-2, -1, 0, 2, 3, 1};
        this.sideVanillaMap = new int[]{1, 2, 5, 3, 4};
        this.fullVanillaBlocks = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Block[]{Blocks.redstone_torch, Blocks.unlit_redstone_torch, Blocks.lever, Blocks.stone_button, Blocks.wooden_button, Blocks.redstone_block}));
    }
}

