/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McMultipartSPH;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventHandler {
    private ThreadLocal<Object> placing = new ThreadLocal();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.worldObj.isRemote) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            if (EventHandler.place(event.entityPlayer, event.entityPlayer.worldObj)) {
                event.setCanceled(true);
            }
            this.placing.set(null);
        }
    }

    public static boolean place(EntityPlayer player, World world) {
        TileMultipart tile;
        MovingObjectPosition hit = RayTracer.reTrace((World)world, (EntityPlayer)player);
        if (hit == null) {
            return false;
        }
        BlockCoord pos = new BlockCoord(hit.blockX, hit.blockY, hit.blockZ).offset(hit.sideHit);
        ItemStack held = player.getHeldItem();
        McBlockPart part = null;
        if (held == null) {
            return false;
        }
        Block heldBlock = Block.getBlockFromItem((Item)held.getItem());
        if (heldBlock == Blocks.air) {
            return false;
        }
        if (heldBlock == Blocks.torch) {
            part = TorchPart.placement(world, pos, hit.sideHit);
        } else if (heldBlock == Blocks.lever) {
            part = LeverPart.placement(world, pos, player, hit.sideHit);
        } else if (heldBlock == Blocks.stone_button) {
            part = ButtonPart.placement(world, pos, hit.sideHit, 0);
        } else if (heldBlock == Blocks.wooden_button) {
            part = ButtonPart.placement(world, pos, hit.sideHit, 1);
        } else if (heldBlock == Blocks.redstone_torch) {
            part = RedstoneTorchPart.placement(world, pos, hit.sideHit);
        }
        if (part == null) {
            return false;
        }
        if (world.isRemote && !player.isSneaking()) {
            Vector3 f = new Vector3(hit.hitVec).add((double)(-hit.blockX), (double)(-hit.blockY), (double)(-hit.blockZ));
            Block block = world.getBlock(hit.blockX, hit.blockY, hit.blockZ);
            if (!EventHandler.ignoreActivate(block) && block.onBlockActivated(world, hit.blockX, hit.blockY, hit.blockZ, player, hit.sideHit, (float)f.x, (float)f.y, (float)f.z)) {
                player.swingItem();
                PacketCustom.sendToServer((Packet)new C08PacketPlayerBlockPlacement(hit.blockX, hit.blockY, hit.blockZ, hit.sideHit, player.inventory.getCurrentItem(), (float)f.x, (float)f.y, (float)f.z));
                return true;
            }
        }
        if ((tile = TileMultipart.getOrConvertTile(world, pos)) == null || !tile.canAddPart(part)) {
            return false;
        }
        if (!world.isRemote) {
            TileMultipart.addPart(world, pos, part);
            world.playSoundEffect((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, part.getBlock().stepSound.func_150496_b(), (part.getBlock().stepSound.getVolume() + 1.0f) / 2.0f, part.getBlock().stepSound.getPitch() * 0.8f);
            if (!player.capabilities.isCreativeMode) {
                --held.stackSize;
                if (held.stackSize == 0) {
                    player.inventory.mainInventory[player.inventory.currentItem] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
                }
            }
        } else {
            player.swingItem();
            new PacketCustom(McMultipartSPH.channel, 1).sendToServer();
        }
        return true;
    }

    private static boolean ignoreActivate(Block block) {
        return block instanceof BlockFence;
    }
}

