/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.minecraft.IPartMeta;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class PartMetaAccess
implements IBlockAccess {
    public IPartMeta part;
    private BlockCoord pos;

    public PartMetaAccess(IPartMeta p) {
        this.part = p;
        this.pos = p.getPos();
    }

    public Block getBlock(int i, int j, int k) {
        if (i == this.pos.x && j == this.pos.y && k == this.pos.z) {
            return this.part.getBlock();
        }
        return this.part.getWorld().getBlock(i, j, k);
    }

    public TileEntity getTileEntity(int i, int j, int k) {
        if (i == this.pos.x && j == this.pos.y && k == this.pos.z) {
            throw new IllegalArgumentException("Unsupported Operation");
        }
        return this.part.getWorld().getTileEntity(i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightBrightnessForSkyBlocks(int i, int j, int k, int l) {
        return this.part.getWorld().getLightBrightnessForSkyBlocks(i, j, k, l);
    }

    public int getBlockMetadata(int i, int j, int k) {
        if (i == this.pos.x && j == this.pos.y && k == this.pos.z) {
            return this.part.getMetadata() & 0xF;
        }
        return this.part.getWorld().getBlockMetadata(i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAirBlock(int i, int j, int k) {
        throw new IllegalArgumentException("Unsupported Operation");
    }

    @SideOnly(value=Side.CLIENT)
    public BiomeGenBase getBiomeGenForCoords(int i, int j) {
        return this.part.getWorld().getBiomeGenForCoords(i, j);
    }

    @SideOnly(value=Side.CLIENT)
    public int getHeight() {
        return this.part.getWorld().getHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean extendedLevelsInChunkCache() {
        return this.part.getWorld().extendedLevelsInChunkCache();
    }

    public int isBlockProvidingPowerTo(int i, int j, int k, int l) {
        throw new IllegalArgumentException("Unsupported Operation");
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.part.getWorld().isSideSolid(x, y, z, side, _default);
    }
}

