/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TRandomUpdateTick;
import codechicken.multipart.TickScheduler;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McMultipartSPH;
import codechicken.multipart.minecraft.TorchPart;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneTorchPart
extends TorchPart
implements IFaceRedstonePart,
TRandomUpdateTick {
    public static BlockRedstoneTorch torchActive = (BlockRedstoneTorch)Blocks.redstone_torch;
    public static BlockRedstoneTorch torchIdle = (BlockRedstoneTorch)Blocks.unlit_redstone_torch;
    private BurnoutEntry burnout;

    public RedstoneTorchPart() {
    }

    public RedstoneTorchPart(int meta) {
        super(meta);
    }

    @Override
    public Block getBlock() {
        return this.active() ? torchActive : torchIdle;
    }

    public boolean active() {
        return (this.meta & 0x10) > 0;
    }

    @Override
    public String getType() {
        return "mc_redtorch";
    }

    @Override
    public int sideForMeta(int meta) {
        return super.sideForMeta(meta & 7);
    }

    @Override
    public Cuboid6 getBounds() {
        return this.getBounds(this.meta & 7);
    }

    public static McBlockPart placement(World world, BlockCoord pos, int side) {
        if (side == 0) {
            return null;
        }
        pos = pos.copy().offset(side ^ 1);
        if (!world.isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        return new RedstoneTorchPart(sideMetaMap[side ^ 1] | 0x10);
    }

    @Override
    public void randomDisplayTick(Random random) {
        if (!this.active()) {
            return;
        }
        double d0 = (double)this.x() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
        double d1 = (double)this.y() + 0.7 + ((double)random.nextFloat() - 0.5) * 0.2;
        double d2 = (double)this.z() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
        double d3 = 0.22;
        double d4 = 0.27;
        World world = this.world();
        int m = this.meta & 7;
        if (m == 1) {
            world.spawnParticle("reddust", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (m == 2) {
            world.spawnParticle("reddust", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (m == 3) {
            world.spawnParticle("reddust", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (m == 4) {
            world.spawnParticle("reddust", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.spawnParticle("reddust", d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack((Block)torchActive);
    }

    @Override
    public void onNeighborChanged() {
        if (!this.world().isRemote && !this.dropIfCantStay() && this.isBeingPowered() == this.active()) {
            this.scheduleTick(2);
        }
    }

    public boolean isBeingPowered() {
        int side = metaSideMap[this.meta & 7];
        return RedstoneInteractions.getPowerTo(this, side) > 0;
    }

    @Override
    public void scheduledTick() {
        if (!this.world().isRemote && this.isBeingPowered() == this.active()) {
            this.toggle();
        }
    }

    @Override
    public void randomUpdate() {
        this.scheduledTick();
    }

    @Override
    public void onWorldJoin() {
        TickScheduler.loadRandomTick(this);
    }

    private boolean burnedOut(boolean add) {
        BurnoutEntry b;
        long time = this.world().getTotalWorldTime();
        while (this.burnout != null && this.burnout.timeout <= time) {
            this.burnout = this.burnout.next;
        }
        if (add) {
            BurnoutEntry e = new BurnoutEntry(this.world().getTotalWorldTime() + 60L);
            if (this.burnout == null) {
                this.burnout = e;
            } else {
                b = this.burnout;
                while (b.next != null) {
                    b = b.next;
                }
                b.next = e;
            }
        }
        if (this.burnout == null) {
            return false;
        }
        int i = 0;
        b = this.burnout;
        while (b != null) {
            ++i;
            b = b.next;
        }
        return i >= 8;
    }

    private void toggle() {
        if (this.active()) {
            if (this.burnedOut(true)) {
                World world = this.world();
                Random rand = world.rand;
                world.playSoundEffect((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.fizz", 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
                McMultipartSPH.spawnBurnoutSmoke(world, this.x(), this.y(), this.z());
            }
        } else if (this.burnedOut(false)) {
            return;
        }
        this.meta = (byte)(this.meta ^ 0x10);
        this.sendDescUpdate();
        this.tile().markDirty();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(1);
    }

    @Override
    public void drop() {
        this.meta = (byte)(this.meta | 0x10);
        super.drop();
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
    }

    @Override
    public void onAdded() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
        this.onNeighborChanged();
    }

    @Override
    public int strongPowerLevel(int side) {
        return side == 1 && this.active() ? 15 : 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() && side != metaSideMap[this.meta & 7] ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return metaSideMap[this.meta & 7];
    }

    public class BurnoutEntry {
        long timeout;
        BurnoutEntry next;

        public BurnoutEntry(long l) {
            this.timeout = l;
        }
    }
}

