/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ExtendedCreativeInv
implements IInventory {
    PlayerSave playerSave;
    Side side;

    public ExtendedCreativeInv(PlayerSave playerSave, Side side) {
        this.playerSave = playerSave;
        this.side = side;
    }

    public int getSizeInventory() {
        return 54;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.side.isClient()) {
            return NEIClientConfig.creativeInv[slot];
        }
        return this.playerSave.creativeInv[slot];
    }

    public ItemStack decrStackSize(int slot, int size) {
        ItemStack item = this.getStackInSlot(slot);
        if (item != null) {
            if (item.stackSize <= size) {
                ItemStack itemstack = item;
                this.setInventorySlotContents(slot, null);
                this.markDirty();
                return itemstack;
            }
            ItemStack itemstack1 = item.splitStack(size);
            if (item.stackSize == 0) {
                this.setInventorySlotContents(slot, null);
            }
            this.markDirty();
            return itemstack1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getStackInSlotOnClosing(int slot) {
        ExtendedCreativeInv extendedCreativeInv = this;
        synchronized (extendedCreativeInv) {
            ItemStack stack = this.getStackInSlot(slot);
            this.setInventorySlotContents(slot, null);
            return stack;
        }
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (this.side.isClient()) {
            NEIClientConfig.creativeInv[slot] = stack;
        } else {
            this.playerSave.creativeInv[slot] = stack;
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return "Extended Creative";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        if (this.side.isServer()) {
            this.playerSave.setCreativeDirty();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }
}

