/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.LangProxy;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class NEIClientUtils
extends NEIServerUtils {
    public static LangProxy lang = new LangProxy("nei");

    public static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static String translate(String key, Object ... params) {
        return lang.format(key, params);
    }

    public static void printChatMessage(IChatComponent msg) {
        if (NEIClientUtils.mc().ingameGUI != null) {
            NEIClientUtils.mc().ingameGUI.getChatGUI().printChatMessage(msg);
        }
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.mc().playerController.windowClick(((GuiContainer)NEIClientUtils.mc().currentScreen).inventorySlots.windowId, -999, 0, 0, (EntityPlayer)NEIClientUtils.mc().thePlayer);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        ItemStack stack;
        ItemStack itemStack = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc().thePlayer.openContainer.getSlot(slotNumber).getStack();
        if (stack == null) {
            return;
        }
        if (stack.stackSize == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.copy();
            --stack.stackSize;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        NEICPH.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(ItemStack type) {
        Container c = NEIClientUtils.getGuiContainer().inventorySlots;
        for (int i = 0; i < c.inventorySlots.size(); ++i) {
            ItemStack stack;
            Slot slot = c.getSlot(i);
            if (slot == null || (stack = slot.getStack()) == null || stack.getItem() != type.getItem() || stack.getItemDamage() != type.getItemDamage()) continue;
            NEIClientUtils.setSlotContents(i, null, true);
            slot.putStack(null);
        }
    }

    public static ItemStack getHeldItem() {
        return NEIClientUtils.mc().thePlayer.inventory.getItemStack();
    }

    public static void setSlotContents(int slot, ItemStack item, boolean containerInv) {
        NEICPH.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc().thePlayer.inventory.setItemStack(item);
        }
    }

    public static void cheatItem(ItemStack stack, int button, int mode) {
        if (!NEIClientConfig.canCheatItem(stack)) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey() && NEIClientConfig.hasSMPCounterPart()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                ItemStack inf;
                if (!handler.canHandleItem(stack) || (inf = handler.getInfiniteItem(stack)) == null) continue;
                NEIClientUtils.giveStack(inf, inf.stackSize, true);
                return;
            }
            NEIClientUtils.cheatItem(stack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(stack, 1);
        } else if (mode == 1 && stack.stackSize < stack.getMaxStackSize()) {
            NEIClientUtils.giveStack(stack, stack.getMaxStackSize() - stack.stackSize);
        } else {
            int amount = NEIClientConfig.getItemQuantity();
            if (amount == 0) {
                amount = stack.getMaxStackSize();
            }
            NEIClientUtils.giveStack(stack, amount);
        }
    }

    public static void giveStack(ItemStack itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.stackSize);
    }

    public static void giveStack(ItemStack itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    public static void giveStack(ItemStack base, int i, boolean infinite) {
        ItemStack stack = NEIClientUtils.copyStack(base, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ItemStack typestack = NEIClientUtils.copyStack(stack, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((EntityPlayer)NEIClientUtils.mc().thePlayer, stack) && NEIClientUtils.mc().currentScreen instanceof GuiContainer) {
                GuiContainer gui = NEIClientUtils.getGuiContainer();
                LinkedList<Iterable<Integer>> handlerSlots = new LinkedList<Iterable<Integer>>();
                for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                    handlerSlots.add(handler.getItemSpawnSlots(gui, typestack));
                }
                int increment = typestack.getMaxStackSize();
                int given = 0;
                Iterator i$ = Iterables.concat(handlerSlots).iterator();
                while (i$.hasNext()) {
                    int slotNo = (Integer)i$.next();
                    Slot slot = gui.inventorySlots.getSlot(slotNo);
                    if (!slot.isItemValid(typestack) || !InventoryUtils.canStack((ItemStack)slot.getStack(), (ItemStack)typestack)) continue;
                    int qty = Math.min(stack.stackSize - given, increment);
                    int current = slot.getHasStack() ? slot.getStack().stackSize : 0;
                    qty = Math.min(qty, slot.getSlotStackLimit() - current);
                    ItemStack newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.putStack(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                    if ((given += qty) < stack.stackSize) continue;
                    break;
                }
                if (given > 0) {
                    NEICPH.sendGiveItem(NEIClientUtils.copyStack(typestack, given), false, false);
                }
            } else {
                NEICPH.sendGiveItem(stack, infinite, true);
            }
        } else {
            int qty;
            for (int given = 0; given < stack.stackSize; given += qty) {
                qty = Math.min(stack.stackSize - given, stack.getMaxStackSize());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.item"), NEIClientUtils.mc().thePlayer.getCommandSenderName(), Item.getIdFromItem((Item)stack.getItem()), qty, stack.getItemDamage(), stack.hasTagCompound() ? stack.getTagCompound().toString() : "", Item.itemRegistry.getNameForObject((Object)stack.getItem()));
            }
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.getInsertibleQuantity((InventoryRange)new InventoryRange((IInventory)player.inventory, 0, 36), (ItemStack)itemstack) > 0;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getGamemode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc().playerController.isInCreativeMode()) {
            return 1;
        }
        if (NEIClientUtils.mc().playerController.currentGameType.isAdventure()) {
            return 3;
        }
        return 0;
    }

    public static boolean isValidGamemode(String s) {
        return s.equals("survival") || NEIClientConfig.canPerformAction(s) && Arrays.asList(NEIClientConfig.getStringArrSetting("inventory.gamemodes")).contains(s);
    }

    public static int getNextGamemode() {
        int mode;
        int nmode = mode = NEIClientUtils.getGamemode();
        while ((nmode = (nmode + 1) % NEIActions.gameModes.length) != mode && !NEIClientUtils.isValidGamemode(NEIActions.gameModes[nmode])) {
        }
        return nmode;
    }

    public static void cycleGamemode() {
        int nmode;
        int mode = NEIClientUtils.getGamemode();
        if (mode == (nmode = NEIClientUtils.getNextGamemode())) {
            return;
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendGamemode(nmode);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), NEIClientUtils.getGameType(nmode), NEIClientUtils.mc().thePlayer.getCommandSenderName());
        }
    }

    public static long getTime() {
        return NEIClientUtils.mc().theWorld.getWorldInfo().getWorldTime();
    }

    public static void setTime(long l) {
        NEIClientUtils.mc().theWorld.getWorldInfo().setWorldTime(l);
    }

    public static void setHourForward(int hour) {
        long day = NEIClientUtils.getTime() / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetTime(hour);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), newTime);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        if (command.length() == 0) {
            return;
        }
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Integer) && !(args[i] instanceof Long)) continue;
            messageformat.setFormatByArgumentIndex(i, numberformat);
        }
        NEIClientUtils.mc().thePlayer.sendChatMessage(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.mc().theWorld.getWorldInfo().isRaining();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc().thePlayer.getCommandSenderName());
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleMagnetMode();
        }
    }

    public static ArrayList<int[]> concatIntegersToRanges(List<Integer> damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList<int[]> addIntegersToRanges(List<int[]> ranges, List<Integer> damages) {
        for (int[] range : ranges) {
            for (int integer = range[0]; integer <= range[1]; ++integer) {
                damages.add(integer);
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.world.nbt.setInteger("quantity", i);
        NEIClientConfig.world.saveNBT();
        LayoutManager.quantity.setText(Integer.toString(i));
    }

    public static GuiContainer getGuiContainer() {
        if (NEIClientUtils.mc().currentScreen instanceof GuiContainer) {
            return (GuiContainer)NEIClientUtils.mc().currentScreen;
        }
        return null;
    }

    public static boolean altKey() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static void playClickSound() {
        NEIClientUtils.mc().getSoundHandler().playSound((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }
}

