/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ServerUtils;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEISPH;
import java.io.File;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerSave {
    public String username;
    private File saveFile;
    private NBTTagCompound nbt;
    public ItemStack[] creativeInv;
    private boolean creativeInvDirty;
    private boolean isDirty;
    private boolean wasOp;

    public PlayerSave(String playername, File saveLocation) {
        this.username = playername;
        this.wasOp = ServerUtils.isPlayerOP((String)playername);
        this.saveFile = new File(saveLocation, this.username + ".dat");
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        this.load();
    }

    private void load() {
        this.nbt = new NBTTagCompound();
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.saveFile.length() > 0L) {
                this.nbt = CompressedStreamTools.read((File)this.saveFile);
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading player save: " + this.username, (Throwable)e);
        }
        this.loadCreativeInv();
    }

    private void loadCreativeInv() {
        this.creativeInv = new ItemStack[54];
        NBTTagList itemList = this.nbt.getTagList("creativeitems", 10);
        if (itemList != null) {
            InventoryUtils.readItemStacksFromTag((ItemStack[])this.creativeInv, (NBTTagList)itemList);
        }
    }

    public void save() {
        if (!this.isDirty) {
            return;
        }
        if (this.creativeInvDirty) {
            this.saveCreativeInv();
        }
        try {
            CompressedStreamTools.write((NBTTagCompound)this.nbt, (File)this.saveFile);
            this.isDirty = false;
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error saving player: " + this.username, (Throwable)e);
        }
    }

    private void saveCreativeInv() {
        NBTTagList invsave = InventoryUtils.writeItemStacksToTag((ItemStack[])this.creativeInv);
        this.nbt.setTag("creativeitems", (NBTBase)invsave);
        this.creativeInvDirty = false;
    }

    public void setCreativeDirty() {
        this.isDirty = true;
        this.creativeInvDirty = true;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void updateOpChange(EntityPlayerMP player) {
        boolean isOp = ServerUtils.isPlayerOP((String)this.username);
        if (isOp != this.wasOp) {
            NEISPH.sendHasServerSideTo(player);
            this.wasOp = isOp;
        }
    }

    public boolean isActionEnabled(String name) {
        return this.getEnabledActions().getBoolean(name);
    }

    private NBTTagCompound getEnabledActions() {
        NBTTagCompound tag = this.nbt.getCompoundTag("enabledActions");
        if (!this.nbt.hasKey("enabledActions")) {
            this.nbt.setTag("enabledActions", (NBTBase)tag);
        }
        return tag;
    }

    public void enableAction(String name, boolean enabled) {
        this.getEnabledActions().setBoolean(name, enabled);
        NEISPH.sendActionEnabled(ServerUtils.getPlayer((String)this.username), name, enabled);
        this.setDirty();
    }
}

